#! /soft/general/R-2.13.0/bin/Rscript 
rm(list=ls(all=TRUE))

########################################################################
# HumMeth27QCReport.R a parser of the HumMeth27QCReport R package
# Copyright (C) 2011  Andreu Alibes (aalibes@gmail.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
########################################################################



##First read in the arguments listed at the command line
args=(commandArgs(TRUE))

##args is now a list of character vectors
## First check to see if arguments are passed.
## Then cycle through each element of the list and evaluate the expressions.
if(length(args)==0){
    print("No arguments supplied.")
    ##supply default values
    Directory = ""
    Plat = ""
    pvalue = ""
    chrom = ""
    method = ""
} else {
#   print(args)
    for(i in 1:length(args)){
         eval(parse(text=args[[i]]))
    }
}

library("HumMeth27QCReport")
Dir <- Directory
ImportDataR <- ImportData(Dir)
normMvalues <- HumMeth27QCReport(ImportDataR, platform = Plat, pval = pvalue, ChrX = chrom, ClustMeth=method)
