/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSMFDump {
    private POIFSFileSystem fs;

    public HSMFDump(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public void dump() throws IOException {
        ChunkGroup[] chunkGroups;
        for (ChunkGroup chunks : chunkGroups = POIFSChunkParser.parse(this.fs)) {
            System.out.println(chunks.getClass().getSimpleName());
            for (Chunk chunk : chunks.getChunks()) {
                MAPIProperty attr = MAPIProperty.get(chunk.getChunkId());
                String idName = attr.id + " - " + attr.name;
                if (attr == MAPIProperty.UNKNOWN) {
                    idName = chunk.getChunkId() + " - (unknown)";
                }
                System.out.println("   " + idName + " - " + Types.asName(chunk.getType()));
                System.out.println("       " + chunk.toString());
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        for (String file : args) {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
            HSMFDump dump = new HSMFDump(fs);
            dump.dump();
        }
    }
}

