/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.StringChunk;

public final class RecipientChunks
implements ChunkGroup {
    public static final String PREFIX = "__recip_version1.0_#";
    public static final MAPIProperty RECIPIENT_NAME = MAPIProperty.DISPLAY_NAME;
    public static final MAPIProperty DELIVERY_TYPE = MAPIProperty.ADDRTYPE;
    public static final MAPIProperty RECIPIENT_EMAIL_ADDRESS = MAPIProperty.EMAIL_ADDRESS;
    public static final MAPIProperty RECIPIENT_SEARCH = MAPIProperty.SEARCH_KEY;
    public static final MAPIProperty RECIPIENT_SMTP_ADDRESS = MAPIProperty.SMTP_ADDRESS;
    public static final MAPIProperty RECIPIENT_DISPLAY_NAME = MAPIProperty.RECIPIENT_DISPLAY_NAME;
    public int recipientNumber = -1;
    public ByteChunk recipientSearchChunk;
    public StringChunk recipientNameChunk;
    public StringChunk recipientEmailChunk;
    public StringChunk recipientSMTPChunk;
    public StringChunk deliveryTypeChunk;
    public StringChunk recipientDisplayNameChunk;
    private List<Chunk> allChunks = new ArrayList<Chunk>();

    public RecipientChunks(String name) {
        int splitAt = name.lastIndexOf(35);
        if (splitAt > -1) {
            String number = name.substring(splitAt + 1);
            try {
                this.recipientNumber = Integer.parseInt(number, 16);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid recipient number in name " + name);
            }
        }
    }

    public String getRecipientName() {
        if (this.recipientNameChunk != null) {
            return this.recipientNameChunk.getValue();
        }
        if (this.recipientDisplayNameChunk != null) {
            return this.recipientDisplayNameChunk.getValue();
        }
        return null;
    }

    public String getRecipientEmailAddress() {
        String search;
        String name;
        if (this.recipientSMTPChunk != null) {
            return this.recipientSMTPChunk.getValue();
        }
        if (this.recipientEmailChunk != null) {
            String email = this.recipientEmailChunk.getValue();
            int cne = email.indexOf("/CN=");
            if (cne == -1) {
                return email;
            }
            return email.substring(cne + 4);
        }
        if (this.recipientNameChunk != null && (name = this.recipientNameChunk.getValue()).indexOf(64) > -1) {
            if (name.startsWith("'") && name.endsWith("'")) {
                return name.substring(1, name.length() - 1);
            }
            return name;
        }
        if (this.recipientSearchChunk != null && (search = this.recipientSearchChunk.getAs7bitString()).indexOf("SMTP:") != -1) {
            return search.substring(search.indexOf("SMTP:") + 5);
        }
        return null;
    }

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    public Chunk[] getChunks() {
        return this.getAll();
    }

    public void record(Chunk chunk) {
        if (chunk.getChunkId() == RecipientChunks.RECIPIENT_SEARCH.id) {
            this.recipientSearchChunk = (ByteChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_NAME.id) {
            this.recipientDisplayNameChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_DISPLAY_NAME.id) {
            this.recipientNameChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_EMAIL_ADDRESS.id) {
            this.recipientEmailChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_SMTP_ADDRESS.id) {
            this.recipientSMTPChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.DELIVERY_TYPE.id) {
            this.deliveryTypeChunk = (StringChunk)chunk;
        }
        this.allChunks.add(chunk);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecipientChunksSorter
    implements Comparator<RecipientChunks> {
        @Override
        public int compare(RecipientChunks a, RecipientChunks b) {
            if (a.recipientNumber < b.recipientNumber) {
                return -1;
            }
            if (a.recipientNumber > b.recipientNumber) {
                return 1;
            }
            return 0;
        }
    }
}

