/*
 * Decompiled with CFR 0.152.
 */
package be.cropdesign.iprscan;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLToExcel {
    private XSSFWorkbook wb;
    private XSSFSheet sheet;
    private XSSFRow myRow;
    private XSSFCell myCell;
    private String XMLFile;
    private int rownr;
    private int colnr;
    private int maxColnr;

    public XMLToExcel(XSSFWorkbook wb, XSSFSheet sheet, XSSFRow myRow, XSSFCell myCell, String XMLFile) {
        this.wb = wb;
        this.sheet = sheet;
        this.myRow = myRow;
        this.myCell = myCell;
        this.XMLFile = XMLFile;
        this.rownr = 0;
        this.colnr = 0;
        this.makeDOMParser();
        this.setColumnWidth();
    }

    public void makeDOMParser() {
        try {
            File file = new File(this.XMLFile);
            if (file.exists()) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                doc.getDocumentElement().normalize();
                this.parseProteins(doc);
            } else {
                System.err.println("The XML file you try to convert to Excel does not exist.");
            }
        }
        catch (IOException ioe) {
            System.err.println("Input/output exception: " + ioe);
        }
        catch (SAXException saxe) {
            System.err.println("SAX parsing exception: " + saxe);
        }
        catch (FactoryConfigurationError fce) {
            System.err.println("Factory configuration error: " + fce);
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Parser configuration exception: " + pce);
        }
    }

    public void parseProteins(Document doc) {
        NodeList proteinLst = doc.getElementsByTagName("protein");
        if (proteinLst != null && proteinLst.getLength() > 0) {
            int i = 0;
            while (i < proteinLst.getLength()) {
                Node proteinNode = proteinLst.item(i);
                if (proteinNode.getNodeType() == 1) {
                    Element proteinElement = (Element)proteinNode;
                    Attr proteinId = proteinElement.getAttributeNode("id");
                    this.myRow = this.sheet.createRow((int)((short)this.rownr));
                    this.makeCellText(this.colnr, "PROTEIN");
                    this.formatTitle();
                    this.makeCellText(this.colnr + 1, proteinId.getValue());
                    this.formatTitle();
                    this.makeRow();
                    this.parseInterpro(proteinNode);
                }
                ++i;
            }
        } else {
            System.out.print("XML file empty.");
        }
    }

    public void parseInterpro(Node proteinNode) {
        NodeList interproLst = proteinNode.getChildNodes();
        if (interproLst != null && interproLst.getLength() > 0) {
            int j = 0;
            while (j < interproLst.getLength()) {
                Node interproNode = interproLst.item(j);
                if (interproNode.getNodeType() == 1 && interproNode.getNodeName().equals("interpro")) {
                    Element interproElement = (Element)interproNode;
                    Attr interproId = interproElement.getAttributeNode("id");
                    this.makeCellText(this.colnr, interproId.getValue());
                    this.makeBold();
                    Attr interproName = interproElement.getAttributeNode("name");
                    this.makeCellText(this.colnr + 1, interproName.getValue());
                    this.makeBold();
                    Attr interproParentId = interproElement.getAttributeNode("parent_id");
                    this.makeRow();
                    this.parseMatchInterproNode(interproNode);
                    this.makeCellText(this.colnr, "parent ");
                    this.makeItalicRight();
                    if (interproParentId != null) {
                        this.makeCellText(this.colnr + 1, interproParentId.getValue());
                        this.setUpperBorder();
                    } else {
                        this.makeCellText(this.colnr + 1, "No parent");
                        this.setUpperBorder();
                    }
                    this.makeRow();
                    this.parseInterproChild("child_list ", "No children", interproNode);
                    this.parseInterproChild("found_in ", "No entries", interproNode);
                    this.parseInterproChild("contains ", "No entries", interproNode);
                    this.parseGOterms(interproNode);
                }
                ++j;
            }
            this.makeRow();
        }
    }

    public void parseMatchInterproNode(Node interproNode) {
        this.makeTableHeaders();
        NodeList interproChildLst = interproNode.getChildNodes();
        if (interproChildLst != null && interproChildLst.getLength() > 0) {
            int k = 0;
            while (k < interproChildLst.getLength()) {
                Node interproChildNode = interproChildLst.item(k);
                if (interproChildNode.getNodeType() == 1 && interproChildNode.getNodeName().equals("match")) {
                    Element matchElement = (Element)interproChildNode;
                    this.getMatchAttributes(matchElement);
                    this.parseLocationMatch(interproChildNode);
                }
                ++k;
            }
        }
        int i = 1;
        while (i < 8) {
            this.makeCellText(i, " ");
            this.setUpperBorder();
            ++i;
        }
    }

    public void parseLocationMatch(Node node) {
        NodeList locationLst = node.getChildNodes();
        if (locationLst != null && locationLst.getLength() > 0) {
            int l = 0;
            while (l < locationLst.getLength()) {
                Node locationNode = locationLst.item(l);
                if (locationNode.getNodeType() == 1) {
                    Element locationElement = (Element)locationNode;
                    this.getLocationAttributes(locationElement);
                }
                ++l;
            }
        }
    }

    public void parseInterproChild(String nodeName, String emptyNode, Node interproNode) {
        this.makeCellText(0, nodeName);
        this.makeItalicRight();
        this.makeCellText(1, emptyNode);
        NodeList interproChildLst = interproNode.getChildNodes();
        if (interproChildLst != null && interproChildLst.getLength() > 0) {
            int k = 0;
            while (k < interproChildLst.getLength()) {
                NodeList rel_refLst;
                Node interproChildNode = interproChildLst.item(k);
                if (interproChildNode.getNodeType() == 1 && interproChildNode.getNodeName().equals(nodeName.trim()) && (rel_refLst = interproChildNode.getChildNodes()) != null && rel_refLst.getLength() > 0) {
                    int s = 0;
                    while (s < rel_refLst.getLength()) {
                        Node ref_relNode = rel_refLst.item(s);
                        if (ref_relNode.getNodeType() == 1) {
                            Element ref_relElement = (Element)ref_relNode;
                            Attr ipr_ref = ref_relElement.getAttributeNode("ipr_ref");
                            ++this.colnr;
                            this.makeCellText(this.colnr, ipr_ref.getValue());
                        }
                        ++s;
                    }
                    this.getMaxColumns(this.colnr + rel_refLst.getLength() + 1);
                    this.colnr = 0;
                }
                ++k;
            }
        }
        this.makeRow();
    }

    public void parseGOterms(Node interproNode) {
        this.makeCellText(0, "GO terms ");
        this.makeItalicRight();
        this.makeCellText(1, "no GO terms");
        int rowGO = this.rownr;
        NodeList interproChildLst = interproNode.getChildNodes();
        if (interproChildLst != null && interproChildLst.getLength() > 0) {
            int k = 0;
            while (k < interproChildLst.getLength()) {
                Node interproChildNode = interproChildLst.item(k);
                if (interproChildNode.getNodeType() == 1 && interproChildNode.getNodeName().equals("classification")) {
                    Element classificationElement = (Element)interproChildNode;
                    Attr classificationId = classificationElement.getAttributeNode("id");
                    this.makeCellText(this.colnr + 2, classificationId.getValue());
                    NodeList classificationLst = classificationElement.getChildNodes();
                    if (classificationLst != null && classificationLst.getLength() > 0) {
                        int l = 0;
                        while (l < classificationLst.getLength()) {
                            Node classificationChildNode = classificationLst.item(l);
                            if (classificationChildNode.getNodeType() == 1 && classificationChildNode.getNodeName().equals("category")) {
                                Element categoryElement = (Element)classificationChildNode;
                                this.makeCellText(this.colnr + 1, categoryElement.getTextContent());
                            }
                            if (classificationChildNode.getNodeType() == 1 && classificationChildNode.getNodeName().equals("description")) {
                                Element descriptionElement = (Element)classificationChildNode;
                                this.makeCellText(this.colnr + 3, descriptionElement.getTextContent());
                            }
                            ++l;
                        }
                    }
                    this.makeRow();
                }
                ++k;
            }
            this.getMaxColumns(this.colnr + interproChildLst.getLength() + 1);
        }
        if (this.sheet.getRow(rowGO).getCell(1).toString().equals("no GO terms")) {
            this.makeRow();
        }
        this.makeRow();
    }

    public void getMatchAttributes(Element matchElement) {
        Attr matchDbname = matchElement.getAttributeNode("dbname");
        this.makeCellText(this.colnr + 1, matchDbname.getValue());
        Attr matchId = matchElement.getAttributeNode("id");
        this.makeCellText(this.colnr + 2, matchId.getValue());
        Attr matchName = matchElement.getAttributeNode("name");
        this.makeCellText(this.colnr + 3, matchName.getValue());
        this.wrapText();
    }

    public void getLocationAttributes(Element locationElement) {
        Attr locationScore = locationElement.getAttributeNode("score");
        Attr locationStart = locationElement.getAttributeNode("start");
        Attr locationEnd = locationElement.getAttributeNode("end");
        Attr locationStatus = locationElement.getAttributeNode("status");
        this.makeCellText(this.colnr + 4, locationScore.getValue());
        this.makeCellNumber(this.colnr + 5, Integer.parseInt(locationStart.getValue()));
        this.makeCellNumber(this.colnr + 6, Integer.parseInt(locationEnd.getValue()));
        this.makeCellText(this.colnr + 7, locationStatus.getValue());
        this.makeRow();
    }

    public void makeCellText(int colnr, String content) {
        this.myCell = this.myRow.createCell((int)((short)colnr));
        this.myCell.setCellValue(content);
    }

    public void makeCellNumber(int colnr, int content) {
        this.myCell = this.myRow.createCell((int)((short)colnr));
        this.myCell.setCellValue((double)content);
    }

    public void makeRow() {
        ++this.rownr;
        this.myRow = this.sheet.createRow((int)((short)this.rownr));
    }

    public void makeTableHeaders() {
        this.makeCellText(0, "matches ");
        this.makeItalicRight();
        String[] headers = new String[]{"Method", "Identifier", "Description", "Score", "Start", "End", "Status"};
        int i = 0;
        while (i < headers.length) {
            this.makeCellText(this.colnr + i + 1, headers[i]);
            this.setTitleBorder();
            ++i;
        }
        this.getMaxColumns(this.colnr + headers.length + 1);
        this.makeRow();
    }

    public void formatTitle() {
        XSSFCellStyle style = this.wb.createCellStyle();
        XSSFFont font = this.wb.createFont();
        font.setColor(new XSSFColor(Color.BLUE));
        font.setBold(true);
        font.setFontHeightInPoints((short)12);
        style.setFont((Font)font);
        this.myCell.setCellStyle((CellStyle)style);
    }

    public void setTitleBorder() {
        XSSFCellStyle border = this.wb.createCellStyle();
        border.setBorderBottom((short)6);
        border.setBorderTop((short)1);
        this.myCell.setCellStyle((CellStyle)border);
    }

    public void setUpperBorder() {
        XSSFCellStyle border = this.wb.createCellStyle();
        border.setBorderTop((short)1);
        this.myCell.setCellStyle((CellStyle)border);
    }

    public void makeBold() {
        XSSFCellStyle style = this.wb.createCellStyle();
        XSSFFont font = this.wb.createFont();
        font.setBold(true);
        style.setFont((Font)font);
        this.myCell.setCellStyle((CellStyle)style);
    }

    public void makeItalicRight() {
        XSSFCellStyle style = this.wb.createCellStyle();
        XSSFFont font = this.wb.createFont();
        font.setItalic(true);
        style.setFont((Font)font);
        style.setAlignment((short)3);
        this.myCell.setCellStyle((CellStyle)style);
    }

    public void setColumnWidth() {
        int col = 0;
        while (col < this.maxColnr) {
            this.sheet.autoSizeColumn(col);
            ++col;
        }
        this.sheet.setColumnWidth(1, 3840);
        this.sheet.setColumnWidth(3, 6912);
    }

    public void getMaxColumns(int colnr) {
        if (colnr > this.maxColnr) {
            this.maxColnr = colnr;
        }
    }

    public void wrapText() {
        XSSFCellStyle wrap = this.wb.createCellStyle();
        wrap.setWrapText(true);
        this.myCell.setCellStyle((CellStyle)wrap);
    }
}

