package be.cropdesign.iprscan;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

//include POI 3.8-beta5 jars in classpath
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * the .jar needs as parameters the path to the XML file with the summary tables and 
 * the .raw file with the iprscan results. 
 * Further the path and filename of the exported Excel file (.xlsx) is given as a parameter.
 * java -jar iprscan.jar -xml $XML -raw $raw -excel $excel
 * @author: Katrien Bernaerts and Domantas Motiejunas
 * @date: 21/06/2012
 * @affiliation: CropDesign N.V., a BASF Plant Science Company - Technologiepark 3, 9052 Zwijnaarde - Belgium
 */
public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		/*
		 * store the arguments and their corresponding flags in a HashMap.
		 * The availability of a HashMap with key (-flag) / value (argument) pairs makes it easier
		 * to handle the arguments and their flags.
		 */
		HashMap<String, String> arguments = new HashMap<String, String>();
		if (args.length == 0){
			System.err.println("No arguments were found at the command line.");
		} else {
			for(int i = 0; i < args.length; i++){
				// for the even args. args[0] is a flag, args[1] is the corresponding argument etc.
				if (i % 2 == 0){ 
					arguments.put(args[i], args[i+1]); // define key (-flag) - value (argument) pairs
				}
			}
		}

		
		/*
		 * fetch the argument values for each flag in the FLAGS enumeration
		 */
		String XMLFile = arguments.get(EnumFlags.XML.getFlag());
		String rawFile = arguments.get(EnumFlags.RAW.getFlag());
		String xlsxName = arguments.get(EnumFlags.EXCEL.getFlag());
		
		/*
		 * create an Excel workbook using the Apache POI library
		 * ref: http://sanjaal.com/java/105/java-file/writing-to-excel-file-using-apache-poi/
		 */
		XSSFWorkbook wb = new XSSFWorkbook();
		XSSFRow myRow = null;
		XSSFCell myCell = null;
		
		/*
		 * determine which arguments (-xml or -raw or (-xml && -raw)) were used at the command line,
		 * and execute the methods corresponding with those arguments
		 */
		if(arguments.containsKey(EnumFlags.XML.getFlag()) && arguments.containsKey(EnumFlags.RAW.getFlag())){
			parseXML(wb, myRow, myCell, XMLFile);
			parseRaw(wb, myRow, myCell, rawFile);
		} else if (arguments.containsKey(EnumFlags.XML.getFlag())) {
			parseXML(wb, myRow, myCell, XMLFile);
		} else if (arguments.containsKey(EnumFlags.RAW.getFlag())) {
			parseRaw(wb, myRow, myCell, rawFile);
		}
		
		/*
		 * write the parsed results to Excel
		 */
		FileOutputStream fileOut;
		try {
			fileOut = new FileOutputStream(xlsxName);
			wb.write(fileOut);
			fileOut.close();
		} catch (FileNotFoundException fnf) {
			System.err.println("Filenot found: " + fnf);
		} catch (IOException io) {
			System.err.println("Input/output error: " + io);
		}
	}
	
	/** 
	 * generate Excel tabsheet 2 containing the summary tables obtained by parsing the XML file
	 */
	public static void parseXML(XSSFWorkbook wb, XSSFRow myRow, XSSFCell myCell, String XMLFile){
		XSSFSheet sheet2 = wb.createSheet("summary tables");
		new XMLToExcel(wb, sheet2, myRow, myCell, XMLFile);
	}
	
	/**
	 * generate tabsheet3: write the iprscan results in the .raw file to Excel, tabsheet "iprscan results"
	 */
	public static void parseRaw(XSSFWorkbook wb, XSSFRow myRow, XSSFCell myCell, String rawFile){
		XSSFSheet sheet3 = wb.createSheet("iprscan results");
		new RawToExcel(wb, sheet3,myRow, myCell, rawFile);
	}
}
