/*
 * Decompiled with CFR 0.152.
 */
package be.cropdesign.iprscan;

import be.cropdesign.iprscan.EnumFlags;
import be.cropdesign.iprscan.RawToExcel;
import be.cropdesign.iprscan.XMLToExcel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Main {
    public static void main(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (args.length == 0) {
            System.err.println("No arguments were found at the command line.");
        } else {
            int i = 0;
            while (i < args.length) {
                if (i % 2 == 0) {
                    arguments.put(args[i], args[i + 1]);
                }
                ++i;
            }
        }
        String XMLFile = (String)arguments.get(EnumFlags.XML.getFlag());
        String rawFile = (String)arguments.get(EnumFlags.RAW.getFlag());
        String xlsxName = (String)arguments.get(EnumFlags.EXCEL.getFlag());
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFRow myRow = null;
        XSSFCell myCell = null;
        if (arguments.containsKey(EnumFlags.XML.getFlag()) && arguments.containsKey(EnumFlags.RAW.getFlag())) {
            Main.parseXML(wb, myRow, myCell, XMLFile);
            Main.parseRaw(wb, myRow, myCell, rawFile);
        } else if (arguments.containsKey(EnumFlags.XML.getFlag())) {
            Main.parseXML(wb, myRow, myCell, XMLFile);
        } else if (arguments.containsKey(EnumFlags.RAW.getFlag())) {
            Main.parseRaw(wb, myRow, myCell, rawFile);
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(xlsxName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (FileNotFoundException fnf) {
            System.err.println("Filenot found: " + fnf);
        }
        catch (IOException io) {
            System.err.println("Input/output error: " + io);
        }
    }

    public static void parseXML(XSSFWorkbook wb, XSSFRow myRow, XSSFCell myCell, String XMLFile) {
        XSSFSheet sheet2 = wb.createSheet("summary tables");
        new XMLToExcel(wb, sheet2, myRow, myCell, XMLFile);
    }

    public static void parseRaw(XSSFWorkbook wb, XSSFRow myRow, XSSFCell myCell, String rawFile) {
        XSSFSheet sheet3 = wb.createSheet("iprscan results");
        new RawToExcel(wb, sheet3, myRow, myCell, rawFile);
    }
}

