import sys, os, os.path, tempfile, shutil, re, shlex, subprocess

def stop_err( msg ):
    sys.stderr.write( "%s\n" % msg )
    sys.exit()

# tranform fastx_barcode_splitter result to html
def results_to_html(results_path,html_path,basepath,print_stdout ):
    pat = '%s[/]?([^\t]*)' % basepath
    rep = '<a href=\"\\1\">\\1</a>'
    txt = open(results_path,'r')
    html = open(html_path,'w')
    html.write('<html><body><table border=1>\n')
    try:
        for line in txt:
            html.write('<tr><td>%s</td></tr>' % re.sub('\t','</td><td>',re.sub(pat,rep,line)))
            if print_stdout:
                print >> sys.stdout, '\t'.join(line.split('\t')[:2])
    except Exception, e:
        print(str(e))
        pass
    html.write('</table></body></html>\n')
    html.close()
    txt.close()

def __main__():
    """
           ##params for galaxy wrapper
           $output
           "$output.id"
           "$input.ext"
           "$__new_file_path__"
           --barcodes='$barcodes'
           $BARCODE $input "$input.name" "$output.extra_files_path"
           ## params for fastx_barcode_splitter
            --mismatches $mismatches --partial $partial $EOL
    """
    
    output = sys.argv[1]
    output_unmatched =  sys.argv[2]
    file_ext = sys.argv[3]
    select_barcode = sys.argv[4].replace('--barcodes=','')
    barcodes = os.path.abspath("barcodes")
    with open(barcodes, 'w') as f:
        f.write("barcode\t%s\n" % (select_barcode))
    
    #barcodes = sys.argv[6]
    fastx = sys.argv[5]
    fastx_name = sys.argv[6]
    #extra_files_path = sys.argv[9]
    script_args = ' '.join(sys.argv[7:])
    #Sanitize library name, make sure we can create a file with this name
    lib_name = re.sub('\W','_',re.sub('\.\W*$','',fastx_name))+'_'
    # Check that input datasets exist
    if not os.path.isfile(fastx):
        stop_err('Error: Input file (%s) not found!' % fastx)
    try:
        prefix = lib_name
        cmd_line = 'zcat -f %s | fastx_barcode_splitter.pl --bcfile %s --prefix %s --suffix %s %s' %(fastx,barcodes,prefix,'.'+file_ext,script_args)
        # print >> sys.stderr, cmd_line 
        # Create file to collect results written to stdout
        tmp_dir = tempfile.mkdtemp()
        result_path = tempfile.NamedTemporaryFile(dir=tmp_dir, prefix='results_', suffix='.out' ).name
        result_file = open( result_path, 'wb' )
        proc = subprocess.Popen( args=cmd_line, shell=True, cwd=tmp_dir, stderr=subprocess.PIPE,stdout=result_file.fileno() )
        returncode = proc.wait()
        result_file.close()
        stderr = proc.stderr.read()
        if returncode != 0:
            raise Exception, stderr
        # copy results to ouptut
        #results_to_html(result_path,output,extra_files_path,True)
        # make new datasets for selected barcodes
        flist = os.listdir(tmp_dir)
        for fname in flist:
            if fname.find('_'+barcode+'.'+file_ext) >= 0:
                fpath = os.path.join(tmp_dir,fname)
                shutil.copy2(fpath, output)
        for fname in flist:
            if fname.find('_unmatched.' + file_ext) > 0:
                fpath = os.path.join(tmp_dir, fname)
                shutil.copy2(fpath, output_unmatched)
    except Exception, e:
        raise Exception, 'Exception caught attempting conversion: ' + str( e )

if __name__ == "__main__": __main__()
