# Tutorials

Learn COBRAxy through hands-on tutorials covering the two main usage scenarios.

## Available Tutorials

| Tutorial | Duration | Description |
|----------|----------|-------------|
| [Galaxy Setup](galaxy-setup.md) | 30 min | Set up Galaxy for web-based analysis |
| [Python API Usage](python-api.md) | 45 min | Programmatic analysis with Python |

## Choose Your Path

### Web Interface → [Galaxy Setup Tutorial](galaxy-setup.md)

Set up a local Galaxy instance with COBRAxy tools for point-and-click analysis. Perfect for users who prefer graphical interfaces and don't want to write code.

### Python Programming → [Python API Tutorial](python-api.md)

Learn to call COBRAxy tools programmatically in your analysis pipelines. Ideal for integrating COBRAxy into custom workflows and automation.

## Prerequisites

Before starting the tutorials, make sure you have:

- ✅ [COBRAxy installed](../installation.md)
- ✅ Basic understanding of metabolic modeling (helpful but not required)
- ✅ Familiarity with command line or Python (depending on tutorial)

## Tutorial Data

Download example datasets used in tutorials:

```bash
# Download tutorial data
wget https://github.com/CompBtBs/COBRAxy/releases/download/v1.0/tutorial_data.zip
unzip tutorial_data.zip
```

The tutorial data includes:
- Sample gene expression datasets
- Metabolite abundance data  
- Pre-configured Galaxy workflows
- Expected output files for verification

## Learning Path

We recommend following tutorials in this order:

1. **[Data Formats](data-formats.md)** - Understand input requirements
2. **[Basic Workflow](workflow.md)** - Learn the analysis pipeline
3. Choose your interface:
   - **[Galaxy Setup](galaxy-setup.md)** for web-based analysis
   - **[Python API](python-api.md)** for programmatic analysis

## Getting Help

If you encounter issues during tutorials:

1. Check the specific tutorial's troubleshooting section
2. Refer to the main [Troubleshooting Guide](../troubleshooting.md)
3. Ask questions in [GitHub Discussions](https://github.com/CompBtBs/COBRAxy/discussions)

## Contributing

Found an error or want to improve a tutorial? 

- [Edit on GitHub](https://github.com/CompBtBs/COBRAxy/tree/main/docs/tutorials)
- [Report issues](https://github.com/CompBtBs/COBRAxy/issues)
- Suggest new tutorial topics

Ready to start? Pick your first tutorial above! 🚀