import argparse
import utils.general_utils as utils
from typing import Optional, List
import os
import numpy as np
import pandas as pd
import cobra
from joblib import Parallel, delayed, cpu_count
import sys

################################# process args ###############################
def process_args(args :List[str]) -> argparse.Namespace:
    """
    Processes command-line arguments.

    Args:
        args (list): List of command-line arguments.

    Returns:
        Namespace: An object containing parsed arguments.
    """
    parser = argparse.ArgumentParser(usage = '%(prog)s [options]',
                                     description = 'process some value\'s')
    
    parser.add_argument(
        '-ms', '--model_selector', 
        type = utils.Model, default = utils.Model.ENGRO2, choices = [utils.Model.ENGRO2, utils.Model.Custom],
        help = 'chose which type of model you want use')
    
    parser.add_argument("-mo", "--model", type = str,
        help = "path to input file with custom rules, if provided")

    parser.add_argument("-mn", "--model_name", type = str, help = "custom mode name")

    parser.add_argument('-ol', '--out_log', 
                        help = "Output log")
    
    parser.add_argument('-td', '--tool_dir',
                        type = str,
                        required = True,
                        help = 'your tool directory')
    
    
    parser.add_argument('-im', '--input_medium',
                        required = True,
                        type=str,
                        help = 'input medium')
    
    parser.add_argument('-ir', '--input_ras',
                        required = True,
                        type=str,
                        help = 'input ras')
    
    parser.add_argument('-ot', '--output_type', 
                        type = str,
                        required = True,
                        help = 'output type')
    
    ARGS = parser.parse_args()
    return ARGS

########################### warning ###########################################
def warning(s :str) -> None:
    """
    Log a warning message to an output log file and print it to the console.

    Args:
        s (str): The warning message to be logged and printed.
    
    Returns:
      None
    """
    with open(ARGS.out_log, 'a') as log:
        log.write(s + "\n\n")
    print(s)


def write_to_file(dataset: pd.DataFrame, name: str, keep_index:bool=False)->None:
    dataset.to_csv(ARGS.output_folder + name + ".csv", sep = '\t', index = keep_index)


def generate_model(cell_name, ras, medium):
    # compute FVA 
    pass


############################# main ###########################################
def main() -> None:
    """
    Initializes everything and sets the program in motion based on the fronted input arguments.

    Returns:
        None
    """
    if not os.path.exists('model_generator'):
        os.makedirs('model_generator')

    num_processors = cpu_count()

    global ARGS
    ARGS = process_args(sys.argv)

    ARGS.output_folder = 'model_generator/'
    
    ARGS.output_types = ARGS.output_type.split(",")

    ras = pd.read_table(ARGS.input_ras, header=0, sep=r'\s+', index_col = 0).T
    ras.replace("None", None, inplace=True)

    #medium has rows cells and columns medium reactions, not common reactions set to None
    medium = pd.read_csv(ARGS.input_medium, sep = '\t', header = 0, engine='python', index_col = 0)

    model_type :utils.Model = ARGS.model_selector
    if model_type is utils.Model.Custom:
        model = model_type.getCOBRAmodel(utils.FilePath.fromStrPath(ARGS.model_name), utils.FilePath.fromStrPath(ARGS.model_name).ext)
    else:
        model = model_type.getCOBRAmodel()
    
    '''for index, row in ras.iterrows(): #iterate over cells RAS
        generate_model(index, row, medium.loc[index])'''

    pass
        
##############################################################################
if __name__ == "__main__":
    main()