#!/bin/bash
#SrcFolder='/data/zhang/wuj/scripts/SpliceTrap.0.8'
InputFileName=$1
faorfq=$2
DatabasePrefix=$3
Outputfolder=$4
SrcFolder=$5
Threads=$6
DatabaseFolder=$SrcFolder'/../db/'$DatabasePrefix'/btw/TXdb'
TmpFolderName=`basename $1`
#fasta or fastq

cd $Outputfolder;
#prepare the folder
if [ -d $TmpFolderName.result ];then
        echo "MAPPING: !!!Error, there is already a folder named "$TmpFolderName".result !"
        echo "MAPPING: !!!change the name of that folder first in case I erase them..."
        exit
fi
echo "MAPPING: Start mapping $InputFileName...Creating cache folder $TmpFolderName.result"
mkdir  $TmpFolderName".result"
mkdir $TmpFolderName".result"/cache

cd $TmpFolderName".result"
cd cache
echo "MAPPING: Split to pieces ..."
split -l 1000000 $InputFileName
for name in x*
do

	if [ $faorfq == "fasta" ];then
		add="-f"
	fi
#	if [ $name != $InputFileName ];then
		echo "bowtie -p $Threads -a -v 2 $DatabaseFolder $name $add >$name.btw; perl $SrcFolder/bowtie2eland.pl $name.btw $name $name.eland;rm $name.btw ;perl $SrcFolder/mark.mt.4eland.pl $name.eland >$name.nomt;rm $name.eland">>map.sh
		echo $name >>checklist
#	fi
done

echo "MAPPING: submit scripts..."
perl $SrcFolder/batchqsub.pl map.sh

tasknum=`wc -l map.sh |tr -d "\n"`
#checking..

echo "MAPPING: mapping $InputFileName to TXdb done...start to check.."
while [ 1 ]
do
	if [ -f mapcheck.sh ];then
		rm mapcheck.sh
	fi
	while read checklist
	do

		name=`echo $checklist |tr -d "\n"`
		echo "MAPPING: checking $name...."
		readnum=`wc -l $name | cut -f1 -d" "`
		if [ $faorfq == "fasta" ];then 
			readnum=`echo "$readnum/2"|bc`
		else
			readnum=`echo "$readnum/4"|bc`
		fi
		if [ -f $name.nomt ];then
			bowtienum=`wc -l $name.nomt | cut -f1 -d" "`
		else
			bowtienum=0
		fi
		if [ $bowtienum != $readnum ];then
			echo "bowtie -p $Threads -a -v 2 $DatabaseFolder $name $add >$name.btw; perl $SrcFolder/bowtie2eland.pl $name.btw $name $name.eland;rm $name.btw ;perl $SrcFolder/mark.mt.4eland.pl $name.eland >$name.nomt;rm $name.eland">>mapcheck.sh

		fi
	done <checklist
	if [ -f mapcheck.sh ];then
		checktasknum=`wc -l mapcheck.sh |tr -d "\n"`
		if [ $checktasknum == $tasknum ];then
			echo "MAPPING: warning! none of the mapping tasks properly finished!"
		fi
		echo "MAPPING: resubmit TASKS...."
		perl $SrcFolder/batchqsub.pl mapcheck.sh
	else
		break
	fi
done
echo "MAPPING: Done.....merging files..."
cat *.nomt >$Outputfolder/$TmpFolderName.nomt
cd ../../
rm $TmpFolderName.result -rf
#/data/zhang/wuj/tools/bowtie-0.12.3/bowtie -a $DatabaseFolderTXdb -f

