# this script is a wrapup for Post analysis based on the ratio file output

use strict;
use Getopt::Long;
my $RatioFile="";
my $OutputFile = "";
my $JunctionCut=5;
my $CutoffLevel="M";
my $noIRM = 0;
my $noIRMstr="";

GetOptions (
	"i:s"=>\$RatioFile,
	"o:s"=>\$OutputFile,
	"c:s"=>\$CutoffLevel,
	"noIRM|noirm"=>\$noIRM,
	"j:i"=>\$JunctionCut
);

my $InputParaDes="	Usage of the script:
	-i      input file (.ratio file)
	-o      output file
	-c      Cutoff Level:H/[M]/L
		Means High, Middle or Low
	-j	Junction reads per junction requirement for each exon-isoform [5]
	--noIRM Use the unadjusted inclusion ratios (before IRM correction)
";

if($RatioFile eq "")
{
	print $InputParaDes;
	exit;
}

if($CutoffLevel ne "H" and  $CutoffLevel ne "M" and  $CutoffLevel ne "L")
{
	print $InputParaDes;
	exit;
}
if($noIRM)
{
	$noIRMstr= "noirm";
}


system("perl $SrcFolder/ApplyCutoff.jie.pl $RatioFile $CutoffLevel $JunctionCut  $noIRMstr >$OutputFile.raw");

open(rawfile, "$OutputFile.raw");
open(outfile, ">$OutputFile");
while(my $line=<rawfile>)
{
	chomp($line);
	my @a=split("\t",$line);
	if($noIRM)
	{
		print outfile join("\t",$a[21],$a[1],$a[3],$a[4],$a[5],$a[6],$a[7],$a[11],$a[12],$a[13],$a[14]),"\n";
	}
	else
	{
		print outfile join("\t",$a[21],$a[2],$a[3],$a[4],$a[5],$a[6],$a[7],$a[11],$a[12],$a[13],$a[14]),"\n";
	}
}
close(outfile);
close(rawfile);
