use Getopt::Long;
use strict;

my $InputFileName=$ARGV[0];
my $OutputFileName = $ARGV[0].".hist";
#$OutputFileName=$ARGV[1] if $ARGV[1] ne "";
my $width=0.01;
my $verbose=1;
my $col=2;
my $start=0;
my $end=1.000;


GetOptions (
        'w:f'=>\$width,
	'c:i'=>\$col,
        'start:f'=>\$start,
        'end:f'=>\$end,
        'v'=>\$verbose
);

$width=$width*1;
#print "IRM: #Generate hist with delta width of $width \n";
#print "IRM: #data source from col $col\n";

$col=$col-1;

my @hist;
my $totalnum=0;

open(Input, $InputFileName);
while(my $line=<Input>)
{
	next if($line=~/^#/);
	chomp($line);
	my @array=split(/\s/,$line);
	$hist[int($array[$col]/$width)]++;
	$totalnum++;
	
}
close(Input);

open(OutputFile, ">$OutputFileName");
print OutputFile  "#Width:$width\n";
for(my $i=0;$i<@hist;$i++)
{
	print OutputFile $hist[$i]/$totalnum,"\n";
}
close(OutputFile);
