
# modified from Chenghai Xue's script

#test if qsub works

my $qsub_checker = 0;
if(system("hash qsub >/dev/null"))
{
	$qsub_checker = 0;
}
else
{
	$test_randname=random_sessid();
	system("mkdir $test_randname;");
	system("echo 'mkdir $test_randname/$test_randname' >$test_randname/$test_randname.sh");
	system("mkdir $test_randname/qsub_cache");
	system ("qsub -cwd -v TMPDIR=$test_randname/qsub_cache -V -e $test_randname/qsub_cache -o $test_randname/qsub_cache -N $test_randname  $test_randname/$test_randname.sh");

	$status=0;
	$sec=5;
	while(1)
	{
		$chkresult=`qstat |grep $test_randname |wc -l`;
		chomp($chkresult);
		if ($chkresult == 0)
		{
			$sec=10;
			$status++;
			last if ($status==3);
		}
		else
		{
			$status=0;
			$sec=5;
		}
		print "QSTAT: $chkresult testing tasks running.....$taskname\n";
		sleep($sec);
	}
	print "QSUB: testing done\n";
	print "$test_randname/$test_randname\n";
	if(-d "$test_randname/$test_randname")
	{
		$qsub_checker=1;
		print "QSUB: working well!\n";
	}
#$qsub_checker=`qsub </dev/null 2>&1|grep stdin|wc -l`;
	system("rm $test_randname -rf");
}
#$qsub_checker=0;
if($qsub_checker == 0)
{
	print "QSUB: No GRID qsub found\n";
	print "QSUB: if you are using PBS qsub, please wait for the next version! Thanks.\n";
	print "QSUB: Running in serial mode...\n";
	system("sh $ARGV[0]");
	exit;
}

$performListFile = $ARGV[0];
$taskname = "";
$taskname = $ARGV[1];
if (not $taskname)
{
	$taskname=random_sessid();
}
#$outfullDir = $ARGV[2];
$outfullDir ="qsub_cache";

# correct path
if(! (-d $outfullDir) ){
	system ("mkdir $outfullDir");
}

# create a temp cache
@temp = split("/", $0);
$prog = pop @temp;
$cache = $outfullDir."/".$prog."_".$taskname;
if(! (-d $cache) ){
	system ("mkdir $cache");
}

open (IN_1, "$performListFile") or die "can not open file $performListFile to read\n";
@performList = (<IN_1>);
chomp @performList;
close IN_1 or die "can't close the input file : $!";


$scriptListFile = $outfullDir."/".$taskname."_scripts.list";
open (FSCRIPLIST, ">$scriptListFile");
for($i=0; $i<@performList; $i++){
	$scriptFile = $outfullDir."/".$taskname."_script$i.sh";
	print FSCRIPLIST "$scriptFile\n";
	open (FOUT, ">$scriptFile");

#	print FOUT "#!/usr/bin/sh\n";
	print FOUT "$performList[$i]\n";
			
#		print OUT_1 "$outfile.map\n";
	close (FOUT);
}
close (FSCRIPLIST);

open (IN_2, "$scriptListFile") or die "can not open file $scriptListFile to read\n";
$basename=`basename $performListFile`;
chop($basename);
$taskname=$taskname."_".$basename;
#print $basename;
while(<IN_2>){
	$f = $_;
	chomp $f;
	@temp = split("/", $f);
	$base = pop @temp;
	
	#use default queues
#	print "/opt/n1ge6/bin/lx24-amd64/qsub -l virtual_free=1.7G -cwd -v TMPDIR=$cache -V -e $cache -o $cache -N $taskname.$base $f\n\n\n";
	#system ("qsub -l virtual_free=1.7G -cwd -v TMPDIR=$cache -V -e $cache -o $cache -N $taskname.$base $f");
	system ("qsub -cwd -v TMPDIR=$cache -V -e $cache -o $cache -N $taskname.$base $f");
	
}
close IN_2 or die "can't close the input file : $!";

#start to check stats of qsub tasks
#######################################
my $taskname_query=substr($taskname,0,10);


$status=0;
$sec=60;
while(1)
{
	$chkresult=`qstat |grep $taskname_query |wc -l`;
	chomp($chkresult);
	if ($chkresult == 0)
	{
		$sec=10;
		$status++;
		last if ($status==3);
	}
	else
	{
		$status=0;
		$sec=60;
	}
	print "QSTAT: $chkresult tasks running.....$taskname\n";
	sleep($sec);
}
print "QSUB: done: $taskname \n";
######################################

#
sub random_sessid
{
	#my @chars = (0..9,a..z,A..Z);
	my @chars = ('a'..'z','A'..'Z');
	my $len = 10;
	my $string = join '', map {$chars[rand(@chars)]} (1..$len);
	return $string;
}
