#cluster_to_vina_clusters.R introduces the x, y,z, coordenates of the cluster/-s identified in the vina file configuration how many cluster/-s identified 

#!/usr/bin/env Rscript      
args = commandArgs(trailingOnly=TRUE)

if(length(args) < 8){
  stop("USE: Rscript cluster_to_vina_clusters.R <receptor_name> <ligand_name> <out_PDBQT> <log_file> <eboxsizedata> <session_dir> <receptor_filename> <ligand_filename>")
  #stop("USE: Rscript cluster_to_vina_clusters.R <receptor_name> <ligand_name> <out_PDBQT> <log_file> <eboxsizedata> <out_conf_file>")
}

#Arguments definition 
receptor_name <- args[1]
ligand_name <- args[2]
out_PDBQT <- args[3]
log_file <- args[4]
eboxsizedata <- args[5]
session_dir <- args[6]
#out_conf_file <- args[6]
receptor_filename <- args[7]
ligand_filename <- args[8]

setwd(session_dir)

#print("before reading table")
clusters_file <- read.table("clusterscoordenates.txt", header = TRUE)
#print("After reading table")

value <- 0
el_b_que_me_quedo <- 1
for(v in 1: nrow(clusters_file)){
        coo_x <- clusters_file[v,2]
        coo_y <- clusters_file[v,3]
        coo_z <- clusters_file[v,4]


        #<receptor_PDBQT> <ligand_PDBQT> <out_PDBQT> <log_file> <coo_x > <coo_y> <coo_z> <eboxsizedata> <galaxy out> <v>
        argumentos <- paste(args[1],args[2], args[3], args[4], coo_x, coo_y, coo_z, args[5], v, session_dir, sep = " ")
        script_argumentos <- paste("Rscript vinafilemarkerclusters.R", argumentos, sep = " ")

        system (script_argumentos)
        system (paste("vina --config ", paste(v, "_vinaconfig", sep = ""), sep =""))
        #system (paste("/home/eugenia/workflowsoftware/autodock_vina_1_1_2_linux_x86/bin/vina --config ", paste(v, "_vinaconfig", sep = ""), sep =""))
        #write(paste("/home/eugenia/workflowsoftware/autodock_vina_1_1_2_linux_x86/bin/vina --config ", paste(v, "_vinaconfig", sep = ""), sep =""), file = "commands", append = TRUE)
        #
        
	#Save out pdbqt from Vina 30julio2018
	#print("before scanning")
	outlog_vina <- scan (paste(v, "_vinaconfig", sep = ""), what = character(), quiet = TRUE)
	#print("after scanning")

	pegar_mv_out9 <- paste("mv", outlog_vina[9], sep = " ")
	pegar_v_out <- paste(v,"_", receptor_filename, "_", ligand_filename, "_out_vina.pdbqt", sep = "")
	pegar_dos_outs <- paste(pegar_mv_out9, pegar_v_out, sep = " ")

	
	#print(pegar_dos_outs)
	system(pegar_dos_outs) 

	#Save log pdbqt from Vina 30julio2018
	pegar_mv_out12 <- paste("mv", outlog_vina[12], sep = " ")
	pegar_v_log <- paste(v,"_", receptor_filename, "_", ligand_filename, "_log_vina.log", sep = "")
	pegar_dos_logs <- paste(pegar_mv_out12, pegar_v_log, sep = " ")

	system(pegar_dos_logs) 
	
	#

        #binding_mode1_energy <- scan(args[4], what = character(), quiet = TRUE)[122]
        #if(v == 1) value <- binding_mode1_energy
        #if(value > as.numeric(binding_mode1_energy)){
        #        value <- as.numeric(binding_mode1_energy)
        #        el_b_que_me_quedo <- v
        #}
}

#copiador <- paste(el_b_que_me_quedo, "_vinaconfig", sep="")
#argumentos <- paste("mv", copiador, out_conf_file, sep=" ")
#print(argumentos)
#system(argumentos)

#system(paste("zip all-vinas-out.zip", "*_out_vina", sep = " ")) #antes del 31julio
#system(paste("mv", "all-vinas-out.zip", args[3] , sep = " ")) #antes del 31julio

#system(paste("zip all-vinas-log.zip", "*_log_vina", sep = " ")) #antes del 31julio
#system(paste("mv", "all-vinas-log.zip", args[4] , sep = " ")) #antes del 31julio

#31julio2018 ----> creo que hay que cambiar los guiones porque hoy se ha quedado pillado en los zip que no lo ha hecho
#30agosto2018 -----> voy a hacer el cambio 

# USE THIS FOR keeping stdout but removing stderr
# { cmd 2>&1 >&3 3>&- | logger 3>&-; } 3>&1

system(paste("zip all_vinas_out.zip", "*_out_vina.pdbqt", sep = " ")) #30agosto
system(paste("mv", "all_vinas_out.zip", args[3] , sep = " ")) #30agosto

system(paste("zip all_vinas_log.zip", "*_log_vina.log", sep = " ")) #30agosto
system(paste("mv", "all_vinas_log.zip", args[4] , sep = " ")) #30agosto 



