from rdkit import Chem
from rdkit.Chem import Draw

import sys


if(len(sys.argv) < 3):
    print("Use: ", str(sys.argv[0]), " <chain in smiles> <output png>")
    sys.exit(-1)

chainfile = str(sys.argv[1])
output = str(sys.argv[2])

print(chainfile)
print(output)

with open(chainfile) as f:
    chain = f.readline()


mol = Chem.MolFromSmiles(chain)

Draw.MolToFile(mol, output)


