#clusterfilemaker.R makes a file containg geometric center coordenates for FILL_Xout1.pdb files. X represents envelopes size from 10 to 100    

#!/usr/bin/env Rscript      
args = commandArgs(trailingOnly=TRUE) 

if(length(args) < 1){
  stop("USE: Rscript clusterfilemaker.R <session_id>")
}

#Select the directory where all files are being stored 

session_id <- args[1]

print(session_id)

setwd(session_id) 

#Scan dataset containig FILL_<point>out1.pdb with point from 10 to 500
fill_outs_1 <- scan("templatefillouts1.txt", what = character(), quiet = TRUE)

#Write the head for the file later created which contains the middle point from FILL_<point>out1.pdb with point from 10 to 500 
cabecera_fillfile <- paste("npts", sep = ";")
cabecera <- c("x","y","z")

for(i in 1:3){
  cabecera_fillfile <- paste(cabecera_fillfile, cabecera[i], sep=";")
}
write(cabecera_fillfile, file="fillouts1file.txt", append= TRUE) 

#Loop to read the files FILL_<point>out1.pdb and calculate the middle point
num_points <- 0
start_env <- 10 # to fit the first envelope size. In case to change envelope size, only modify this parameter
jp <- 10 #jump between envelopes size. In case modify jump between envelopes size, only modify this parameter
#In case modify start envelope size and jump, only modify start_env and jp parameters in the script nothing in following steps





num_points <- (start_env - jp)
for(f in 1:length(fill_outs_1)){
#	print(paste("Testing file ", fill_outs_1[f]))
    if(file_test("-f", fill_outs_1[f])){ 
      archivo <- scan(fill_outs_1[f], what = character(), quiet = TRUE)
    }else{
	    next
    }
  
#Make a table with only x, y, z coordenates for C atoms only
salto <- 0
for(i in 1:(length(archivo)-2)){
 if(archivo[i] == "ATOM" && ( archivo[i+2] == "C" || archivo[i+2] == "O" || archivo[i+2] == "H" )){
    salto <- salto + 1
  }
}
tablaC <- matrix(1, nrow = salto, ncol = 4)

#Names for columns
##First column correspond to position for atoms C. This column will be created when the C atom positions will be know
###Write the name for columns and rows
colnames(tablaC) <- c("C Position","X", "Y", "z")
rownames(tablaC) <- 1:salto
  
#Calculate the number of C atoms and to write theirs coordenates x,y,z in the tablaC
salto <- 0
posicionC <-  c()
for(i in 1:(length(archivo)-2)){
 if(archivo[i] == "ATOM" && ( archivo[i+2] == "C" || archivo[i+2] == "O" || archivo[i+2] == "H" )){
    salto <- salto + 1
    posicionC <- c(posicionC, archivo[i+1])
    tablaC[salto,2] <- as.numeric(archivo[i+5])
    tablaC[salto,3] <- as.numeric(archivo[i+6])
    tablaC[salto,4] <- as.numeric(archivo[i+7])
  }
}
  
#Write the C atoms positions in column 1 of the table tablaC
for(i in 1:salto){
tablaC[i,1] <- as.numeric(posicionC[i]) 
}
  
#Calculate middle point for the FILL_<point>out1.pdb given
pto_x_medio <- (max(tablaC[,2]) + min(tablaC[,2]))/2
pto_y_medio <- (max(tablaC[,3]) + min(tablaC[,3]))/2
pto_z_medio <- (max(tablaC[,4]) + min(tablaC[,4]))/2
  
#Write a plain text called fillouts1file.txt which contain in the first column number of point  
#for the envelope according to AutoLigand program. Columns 2,3,4 for coordenates x, y ,z 
#for the middle points for FILL_<point>out1.pdb from 10 to 500 points
num_points <- num_points + jp
write(paste(num_points,pto_x_medio, pto_y_medio, pto_z_medio, sep=";"),file="fillouts1file.txt", append= TRUE)
}









