/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Arrays;
import vcf.Marker;
import vcf.Markers;

public class SampleGenotypeValues {
    private final int sample;
    private final Markers markers;
    private final float[] gtValues;

    public SampleGenotypeValues(Markers markers, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("sample<0: " + n);
        }
        this.sample = n;
        this.markers = markers;
        this.gtValues = new float[markers.sumGenotypes()];
    }

    public synchronized SampleGenotypeValues restrict(int n, int n2) {
        return new SampleGenotypeValues(this, n, n2);
    }

    private SampleGenotypeValues(SampleGenotypeValues sampleGenotypeValues, int n, int n2) {
        this.sample = sampleGenotypeValues.sample;
        this.markers = sampleGenotypeValues.markers.restrict(n, n2);
        int n3 = sampleGenotypeValues.markers.sumGenotypes(n);
        int n4 = sampleGenotypeValues.markers.sumGenotypes(n2);
        this.gtValues = Arrays.copyOfRange(sampleGenotypeValues.gtValues, n3, n4);
    }

    public synchronized float value(int n, int n2) {
        this.checkGenotype(n, n2);
        return this.gtValues[this.markers.sumGenotypes(n) + n2];
    }

    public synchronized void add(double[] dArray) {
        if (dArray.length != this.gtValues.length) {
            String string = "values.length=" + dArray.length;
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            this.gtValues[n] = (float)((double)this.gtValues[n] + dArray[i]);
        }
    }

    public synchronized void add(int n, int n2, double d) {
        this.checkGenotype(n, n2);
        int n3 = this.markers.sumGenotypes(n) + n2;
        this.gtValues[n3] = (float)((double)this.gtValues[n3] + d);
    }

    private void checkGenotype(int n, int n2) {
        int n3 = this.markers.marker(n).nGenotypes();
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("genotype: " + n2);
        }
    }

    public int sample() {
        return this.sample;
    }

    public Markers markers() {
        return this.markers;
    }

    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    public int nMarkers() {
        return this.markers.nMarkers();
    }
}

