#include "clustddp.h"

double logPrior_ij(MODEL *model, DATA *data, int i, int j) {
  int z, y;
  double res = 0.0;
  z = model->dp.z[j];
  y = model->hdp.y[z][i];
  res += log(model->hdp.pi[i][y]);
  return res;
}

double logPrior_Ki(MODEL *model, DATA *data, int i, int k) {
  int y;
  double res = 0.0;
  y = model->hdp.y[k][i];
  res += log(model->hdp.pi[i][k]);  
  return res;
}

double logPrior(MODEL *model, DATA *data) {
  int i, j, y, z;
  double res = 0.0;
  for(j=0;j<data->nbait;j++) {
    z = model->dp.z[j]; 
    for(i=0;i<data->nprey;i++) {
      y = model->hdp.y[z][i];
      res += log(model->hdp.pi[i][y]);
    }
  }
  return res;
}

double logPriorERING(MODEL *model, DATA *data, int ring, int index) {
  int i, j, y, z;
  double res = 0.0;
  for(j=0;j<data->nbait;j++) {
    z = model->ering[ring].dp[index].z[j];
    for(i=0;i<data->nprey;i++) {
      y = model->ering[ring].hdp[index].y[z][i];
      res += log(model->ering[ring].hdp[index].pi[i][y]);
    }
  }
  return res;
}


double logGaussian(const double x, double *omega, double sigma2, const gsl_rng *r) {
  double res;
  double m, v;
  m = omega[0];
  v = omega[1];
  res = - .5 * (x-m) * (x-m) / v - .5 * log(v * 2.0 * M_PI);
  return res; 
}

double loglikBait(MODEL *model, DATA *data, int which, const gsl_rng *r) {
  int i, j, id, id2;
  double loglik = 0.0;
  for(i=0;i<data->nprey;i++) {
    if(data->use[i]) {
      id = model->hdp.y[model->dp.z[which]][i];
      for(j=0;j<data->n_b2ip[which];j++) {
        id2 = data->b2ip[which][j];
        loglik += logGaussian(data->d[id2][i], model->hdp.omega[id], model->sigma2[i], r);
      }
    }
  }
  return loglik;
}

double loglikBait_k(MODEL *model, DATA *data, int which, int k, const gsl_rng *r) {
  int i, j, id, id2;
  double loglik = 0.0;
  for(i=0;i<data->nprey;i++) {
    if(data->use[i]) {
      id = model->hdp.y[k][i];
      for(j=0;j<data->n_b2ip[which];j++) {
        id2 = data->b2ip[which][j];
        loglik += logGaussian(data->d[id2][i], model->hdp.omega[id], model->sigma2[i], r);
      }
    }
  }
  return loglik;
}


double loglik(MODEL *model, DATA *data, const gsl_rng *r) {
  int i,j,k,id,id2;
  double curlik = 0.0;
  for(i=0;i<data->nprey;i++) {
    for(k=0;k<data->nbait;k++) {
      id = model->hdp.y[model->dp.z[k]][i];
      for(j=0;j<data->n_b2ip[k];j++) {
        id2 = data->b2ip[k][j];
        curlik += logGaussian(data->d[id2][i], model->hdp.omega[id], model->sigma2[i], r);
      }
    }
  }
  return curlik;
}

int loglikBaitSample(MODEL *model, DATA *data, int which, double p[], const gsl_rng *r, int *id) {
  int i,j,k,id2;
  double loglik;
  for(k=0;k<model->nb;k++) {
    loglik = 0.0;
    if(id[k]) {
      for(i=0;i<data->nprey;i++) {
        if(data->use[i]) {
          for(j=0;j<data->n_b2ip[which];j++) {
            id2 = data->b2ip[which][j];
            loglik += logGaussian(data->d[id2][i], model->hdp.omega[model->hdp.y[k][i]], model->sigma2[i], r);
          }
        }
      }
    }
    p[k] = loglik; 
  }
  return 0;
} 

double loglikEring(MODEL *model, DATA *data, int ring, int index, const gsl_rng *r) {
  int i,j,k,l,id,id2;
  double loglik = 0.0;
  double d;
  double *omega;
  for(j=0;j<data->nbait;j++) {
    k = model->ering[ring].dp[index].z[j];
    for(i=0;i<data->nprey;i++) {
      id = model->ering[ring].hdp[index].y[k][i];
      omega = model->ering[ring].hdp[index].omega[id];
      for(l=0;l<data->n_b2ip[j];l++) {
        id2 = data->b2ip[j][l];
        d = data->d[id2][i];
        loglik += logGaussian(d, omega, model->sigma2[i], r);
      }
    }
  }
  /* truncation */
  return loglik;
}




