#!/usr/bin/perl

# 17/12/2013

if($#ARGV==0){
	print "This program takes the Saint Output File and produces two matrices.\n";
	print "One has average spectral counts and the other FDR scores,\n";
	print "\nusage:\n $0\n-i [csv saint output file]\n-s [FDR cutoff, default=0.01]\n\n";
	die;
}
else{
	$i=0;
	$cutoff=0.01;
        $spec_cutoff=0;
	while($i<=$#ARGV){
		if($ARGV[$i] eq '-i'){
			$i++;
			$ifile=$ARGV[$i];
		}
		elsif($ARGV[$i] eq '-s'){
			$i++;
			if($ARGV[$i]>1 || $ARGV[$i]<0){  
				die "\nFDR cutoff must be between 0 and 1 \n\n";
			}
			$cutoff=$ARGV[$i];
		}
	        elsif($ARGV[$i] eq '-x'){
			$i++;
			if($ARGV[$i]<0){  
				die "\nAvgSpec cutoff must be > 0 \n\n";
			}
			$spec_cutoff=$ARGV[$i];
		}
		else{
			die "\Incorrect program usage\n\n";
		}
		$i++;
	}
}

$baitn=0, $bait[0]=xxxx, $sig_preysn=0;
$file='';
open(IFILE,"<$ifile") || die "$ifile can't be opened: $!";
{ local $/=undef;  $file=<IFILE>; }
@lines=split /[\r\n]+/, $file;
foreach $line (@lines) {
   	if($line =~ /^Bait/){
	}
	elsif($line =~ /^([^\t]+)\t[^\t]+\t([^\t]+)\t[^\t]+\t[\d]+\t([\d\.]+)\t[\d]+\t[^\t]+\t[^\t]+\t[^\t]+\t[^\t]+\t[^\t]+\t([^\t]+)\t[^\t]+\t([^\t]+)\t/){
		if($1 ne $bait[$baitn]){
			$baitn++;
			$bait[$baitn]=$1;
			$preyn[$baitn]=0;
		}
		$preyn[$baitn]++;
		$preys[$baitn][$preyn[$baitn]]=$2;	
		$avgspec[$baitn][$preyn[$baitn]]=$3;	
		$saint[$baitn][$preyn[$baitn]]=$4;
		$fdr[$baitn][$preyn[$baitn]]=$5;
		if($5 <= $cutoff && $3 >= $spec_cutoff){
			$check_prey=0;
			for($i=1; $i<=$sig_preysn; $i++){
				if($sig_preys[$i] eq $2){
					$check_prey=1;
				}
			}
			if($check_prey==0){
				$sig_preysn++;
				$sig_preys[$sig_preysn]=$2;
			}
		}
	}
	else{
	}
}	
close(IFILE);

open(SC_FILE, ">SC_data.txt");
open(FDR_FILE, ">FDR_data.txt");

for($i=1; $i<=$baitn; $i++){
	print SC_FILE "\t$bait[$i]";
	print FDR_FILE "\t$bait[$i]";
}
print SC_FILE "\n";
print FDR_FILE "\n";
for($i=1; $i<=$sig_preysn; $i++){
	print SC_FILE "$sig_preys[$i]";
	print FDR_FILE "$sig_preys[$i]";
	for($j=1; $j<=$baitn; $j++){
		$krem=0;
		for($k=1; $k<=$preyn[$j]; $k++){;
			if($preys[$j][$k] eq $sig_preys[$i]){
				$krem=$k;
				last;
			}
		}
		if($krem != 0){
			print SC_FILE "\t$avgspec[$j][$krem]";
			print FDR_FILE "\t$fdr[$j][$krem]";
		}
		else{
			print SC_FILE "\t0";
			print FDR_FILE "\t1";
		}
	}
	print SC_FILE "\n";
	print FDR_FILE "\n";
}
close(SC_FILE);
close(FDR_FILE);

