#include "clustddp.h"

/*********************/
/***   Read Data   ***/
/*********************/

void quantiles(MODEL *model, DATA *data) {
  int i,j,cur,id;
  double h1, h2;
  double array[data->nIP];
  double array2[data->nIP * data->nprey];

  for(i=0;i<data->nprey;i++) {
    cur = 0;
    for(j=0;j<data->nIP;j++) {
      array[cur] = data->d[j][i];
      cur++;
    }
    gsl_sort(array, 1, data->nIP);
    h1 = array[data->nIP-1];
    h2 = array[data->nIP-2];
    for(j=0;j<data->nIP;j++) {
      if(strcmp(data->preyName[i], data->baitName[j]) == 0) {
        if(data->d[j][i] == h1) data->d[j][i] = h2;
      }
    }
    for(j=0;j<5;j++) {
      id = (int) ( ((double) j) * 0.25 * ((double) (data->nIP-1)) );
      data->quantiles[i][j] = array[id];
    }
    data->priorScale[i] = GSL_MAX(.5 * (data->quantiles[i][4] - data->quantiles[i][0]), model->minvar);
  } 

  cur = 0;
  for(j=0;j<data->nIP;j++) {
    for(i=0;i<data->nprey;i++) {
      array2[cur] = data->d[j][i];
      cur++;
    }
  }
  gsl_sort(array2, 1, data->nIP * data->nprey);
  id = (int) ( 0.0 * ((double) (data->nIP * data->nprey -1)) );
  data->q[0] = array2[id];
  id = (int) ( 0.25 * ((double) (data->nIP * data->nprey -1)) );
  data->q[1] = array2[id];
  id = (int) ( 0.5 * ((double) (data->nIP * data->nprey -1)) );
  data->q[2] = array2[id];
  id = (int) ( 0.75 * ((double) (data->nIP * data->nprey -1)) );
  data->q[3] = array2[id];
  id = (int) ( 1.0 * ((double) (data->nIP * data->nprey -1)) );
  data->q[4] = array2[id];

  /* for(j=0;j<5;j++) fprintf(stderr, "%.3f\t", data->q[j]); */
}

int readData(FILE *fp, MODEL *model, DATA *data) {
  char buf[10000];
  int i,j,worth;
  double mean;
  
  /* Memory Business */
  assert(data->preyName = (char **) calloc(data->nprey, sizeof(char *)));
  for(i=0;i<data->nprey;i++) assert(data->preyName[i] = (char *) calloc(_MAX_NAME_, sizeof(char)));
  assert(data->baitName = (char **) calloc(data->nIP, sizeof(char *)));
  for(i=0;i<data->nIP;i++) assert(data->baitName[i] = (char *) calloc(_MAX_NAME_, sizeof(char)));
  assert(data->IPName = (char **) calloc(data->nIP, sizeof(char *)));
  for(i=0;i<data->nIP;i++) assert(data->IPName[i] = (char *) calloc(_MAX_NAME_, sizeof(char)));

  assert(data->d = (double **) calloc(data->nIP, sizeof(double *)));  
  for(j=0;j<data->nIP;j++) assert(data->d[j] = (double *) calloc(data->nprey, sizeof(double)));
  assert(data->zero = (int **) calloc(data->nIP, sizeof(int *)));  
  for(j=0;j<data->nIP;j++) assert(data->zero[j] = (int *) calloc(data->nprey, sizeof(int)));
  assert(data->norm = (double *) calloc(data->nIP, sizeof(double)));
  assert(data->self = (int *) calloc(data->nIP, sizeof(int)));
  assert(data->use = (int *) calloc(data->nprey, sizeof(int)));
  assert(data->quantiles = (double **) calloc(data->nprey, sizeof(double *)));
  for(i=0;i<data->nprey;i++) assert(data->quantiles[i] = (double *) calloc(5, sizeof(double))); 
  assert(data->priorScale = (double *) calloc(data->nprey, sizeof(double)));
  assert(data->q = (double *) calloc(5, sizeof(double)));

  /* First Line -- Bait Labels */
  fscanf(fp, "%s", buf);
  for(i=0;i<data->nIP;i++) {
    fscanf(fp, "%s", buf);
    strcpy(data->baitName[i], buf);
  }

  /*
  fscanf(fp, "%s", buf);
  for(i=0;i<data->nIP;i++) {
    fscanf(fp, "%s", buf);
    strcpy(data->IPName[i], buf);
  }
  */
  for(i=0;i<data->nIP;i++) {
	strcpy(data->IPName[i], data->baitName[i]);
  }

  /* Reading the main body of the data */  
  for(i=0;i<data->nprey;i++) {
    fscanf(fp, "%s", buf);
    strcpy(data->preyName[i], buf);
    for(j=0;j<data->nIP;j++) {
      fscanf(fp, "%s", buf);
      data->d[j][i] = atof(buf);
      if(data->d[j][i] == 0.0) data->zero[j][i] = 1;
      else data->zero[j][i] = 0;
    }
  }

  for(j=0;j<data->nIP;j++) data->norm[j] = log(vec_sum(data->d[j], data->nprey));
  mean = vec_med(data->norm, data->nIP);
  for(j=0;j<data->nIP;j++) data->norm[j] -= mean;
  for(j=0;j<data->nIP;j++) data->norm[j] = 0.0;
  for(i=0;i<data->nprey;i++) {
    worth = 0;
    for(j=0;j<data->nIP;j++) {
      if(data->d[j][i] > 0.0) worth++;
    }
    if(worth >= 1) data->use[i] = 1;
  }

  for(j=0;j<data->nIP;j++) {
    data->self[j] = -1;
    for(i=0;i<data->nprey;i++) {
      if(strcmp(data->baitName[j], data->preyName[i]) == 0) {
        data->self[j] = i;
        break;
      }
    }
  }

  quantiles(model, data);

  return 0;
}


/* After here, # of bait <= # of IP */

/**********************/
/*** Initial Values ***/
/**********************/

void initDPclust(MODEL *model, DPclust *dp, DATA *data, const gsl_rng *r) {
  int j;
  /* dp->alpha = ((double) data->nbait); */
  assert(dp->beta = (double *) calloc(model->nb, sizeof(double)));
  assert(dp->z = (int *) calloc(data->nbait, sizeof(int)));  
  for(j=0;j<data->nbait;j++) dp->z[j] = ((int) gsl_ran_flat(r, 0.0, ((double) data->nbait)));
  for(j=0;j<model->nb;j++) dp->beta[j] = 1.0 / ((double) model->nb);
}

void initHDPprior(MODEL *model, HDPprior *hdp, DATA *data, const gsl_rng *r) {
  int i,j,k;
  double p[model->np];
  /* hdp->rho = ((double) (data->nprey * data->nbait));
  hdp->gamma = 1.0; */
  assert(hdp->eta = (double *) calloc(model->np, sizeof(double)));
  assert(hdp->omega = (double **) calloc(model->np, sizeof(double *)));
  for(k=0;k<model->np;k++) assert(hdp->omega[k] = (double *) calloc(_DIM_, sizeof(double)));
  assert(hdp->pi = (double **) calloc(data->nprey, sizeof(double *)));
  for(i=0;i<data->nprey;i++) assert(hdp->pi[i] = (double *) calloc(model->np, sizeof(double)));
  assert(hdp->y= (int **) calloc(model->nb, sizeof(int *)));
  for(i=0;i<model->nb;i++) assert(hdp->y[i] = (int *) calloc(data->nprey, sizeof(int)));
 
  for(k=0;k<model->np;k++) p[k] = 1.0 / ((double) model->np);
  for(k=0;k<model->np;k++) hdp->eta[k] = 1.0 / ((double) model->np);

  hdp->omega[0][0] = 0.0;
  for(k=1;k<model->np;k++) {
    hdp->omega[k][0] = ((double) k) * (data->q[4]-data->q[0]) / ((double) model->np);
  }
  for(k=0;k<model->np;k++) hdp->omega[k][1] = GSL_MAX(model->minvar, 1.0);
  for(j=0;j<model->nb;j++) {
    for(i=0;i<data->nprey;i++) hdp->y[j][i] = ranMultinom(r, p, model->np);
  }

  for(i=0;i<data->nprey;i++) {
    for(k=0;k<model->np;k++) hdp->pi[i][k] = 1.0 / ((double) (model->np));
  }
}


void resetDPclust(MODEL *model, DPclust *dp, DATA *data, const gsl_rng *r) {
  int j;
  for(j=0;j<data->nbait;j++) dp->z[j] = ((int) gsl_ran_flat(r, 0.0, (double) model->nb));
  for(j=0;j<model->nb;j++) dp->beta[j] = 1.0 / ((double) model->nb);
}

void resetHDPprior(MODEL *model, HDPprior *hdp, DATA *data, const gsl_rng *r) {
  int i,j,k;
  double p[model->np];
 
  for(k=0;k<model->np;k++) p[k] = 1.0 / ((double) model->np);
  for(k=0;k<model->np;k++) hdp->eta[k] = 1.0 / ((double) model->np);
  hdp->omega[0][0] = 0.0;
  for(k=1;k<model->np;k++) {
    hdp->omega[k][0] = ((double) k) * (data->q[4]-data->q[0]) / ((double) model->np);
  }
  for(k=0;k<model->np;k++) hdp->omega[k][1] = GSL_MAX(model->minvar, 1.0);
  for(j=0;j<model->nb;j++) {
    for(i=0;i<data->nprey;i++) {
      hdp->y[j][i] = ranMultinom(r, p, model->np);
    }
  }
  for(i=0;i<data->nprey;i++) {
    for(k=0;k<model->np;k++) hdp->pi[i][k] = 1.0 / ((double) (model->np));
  }
}

void resetMODEL(MODEL *model, DATA *data, const gsl_rng *r) {
  int i;
  model->EEattempt = 0;
  model->EEaccept = 0;
  for(i=0;i<data->nprey;i++) model->sigma2[i] = 4.0;
  for(i=0;i<_NUM_RECORDS_;i++) model->reportOrder[i] = i;
  resetDPclust(model, &(model->dp), data, r);
  resetHDPprior(model, &(model->hdp), data, r);
}

void memoryDPclust(MODEL *model, DPclust *dp, DATA *data) {
  /* dp->alpha = ((double) data->nbait);  */
  assert(dp->beta = (double *) calloc(model->nb, sizeof(double)));
  assert(dp->z = (int *) calloc(data->nbait, sizeof(int)));  
}

void memoryHDPprior(MODEL *model, HDPprior *hdp, DATA *data) {
  int i,k;
  /* hdp->rho = ((double) (data->nprey * data->nbait));
  hdp->gamma = 1.0; */
  assert(hdp->eta = (double *) calloc(model->np, sizeof(double)));
  assert(hdp->omega = (double **) calloc(model->np, sizeof(double *)));
  for(k=0;k<model->np;k++) assert(hdp->omega[k] = (double *) calloc(_DIM_, sizeof(double)));
  assert(hdp->pi = (double **) calloc(data->nprey, sizeof(double *)));
  for(i=0;i<data->nprey;i++) assert(hdp->pi[i] = (double *) calloc(model->np, sizeof(double)));
  assert(hdp->y= (int **) calloc(model->nb, sizeof(int *)));
  for(i=0;i<model->nb;i++) assert(hdp->y[i] = (int *) calloc(data->nprey, sizeof(int))); 
}


void initOptimalCluster(MODEL *model, OPTCL *opt, DATA *data) {
  int i,j;
  assert(opt->z = (int *) calloc(data->nbait, sizeof(int)));
  assert(opt->y = (int **) calloc(model->nb, sizeof(int *)));
  for(j=0;j<model->nb;j++) assert(opt->y[j] = (int *) calloc(data->nprey, sizeof(int)));
  assert(opt->phi = (double ***) calloc(model->nb, sizeof(double **)));
  for(j=0;j<model->nb;j++) {
    assert(opt->phi[j] = (double **) calloc(data->nprey, sizeof(double *)));
    for(i=0;i<data->nprey;i++) assert(opt->phi[j][i] = (double *) calloc(_DIM_, sizeof(double)));
  }
}


int initModel(MODEL *model, DATA *data, const gsl_rng *r) {
  int i;
  model->curLadder = model->numLadder - 1 ;
  model->p_ee = 0.3;

  model->curlikHT = GSL_NEGINF;
  model->curlik = GSL_NEGINF;

  initDPclust(model, &(model->dp), data, r);
  initHDPprior(model, &(model->hdp), data, r);
  assert(model->sigma2 = (double *) calloc(data->nprey, sizeof(double)));
  for(i=0;i<data->nprey;i++) model->sigma2[i] = 4.0;

  for(i=0;i<model->numLadder;i++) {
    initERING(model, &(model->ering[i]), data);
    initERING(model, &(model->eringNew[i]), data);
  }

  initEnergyTruncation(model, data);

  model->optCount = 0;
  for(i=0;i<_NUM_RECORDS_;i++) initOptimalCluster(model, &(model->opt[i]), data);

  model->EEattempt = 0;
  model->EEaccept = 0;
  return 0;
}

