#include "clustddp.h"
double takeMean(const double *phi) {
  double res = phi[0];
  return res;
}

void outputClustering(MODEL *model, DATA *data) {
  int i,j,k,l,id,id2;
  int index, indexr; 

  char optname[] = "optcl";
  char optname1[] = "optcl-mu";
  char addname[32];
  char tmpname[32];
  /* report only those k such that at least one j=k */
  FILE *fpb = fopen("Clusters", "w");
  FILE *fpp = fopen("NestedClusters", "w");
  FILE *fpphi1 = fopen("NestedMu", "w");
  FILE *fpphi2 = fopen("NestedSigma2", "w");

  /* Bait Clustering Record */
  fprintf(fpb, "logLik\t");
  for(j=0;j<data->nbait;j++) {
    if(j == (data->nbait-1)) fprintf(fpb, "%s\n", data->baitName[j]);
    else fprintf(fpb, "%s\t", data->baitName[j]);
  }
  for(index=0;index<_NUM_RECORDS_;index++) {
    indexr = model->reportOrder[index];
    fprintf(fpb, "%.2f\t", model->optScores[indexr]);
    for(j=0;j<data->nbait;j++) {
      if(j == (data->nbait-1)) fprintf(fpb, "%d\n", model->opt[indexr].z[j]+1);
      else fprintf(fpb, "%d\t", model->opt[indexr].z[j]+1);
    }
  }
  fclose(fpb);

  /* Prey Clustering Record */
  for(index=0;index<_NUM_RECORDS_;index++) {
    indexr = model->reportOrder[index];
    for(i=0;i<data->nprey;i++) {
      for(k=0;k<model->nb-1;k++) fprintf(fpp, "%d\t", model->opt[indexr].y[k][i]+1);
      fprintf(fpp, "%d\n", model->opt[indexr].y[model->nb-1][i]+1);
    }
  }
  fclose(fpp);

  for(index=0;index<_NUM_RECORDS_;index++) {
    indexr = model->reportOrder[index];
    for(i=0;i<data->nprey;i++) {
      for(k=0;k<model->nb-1;k++) fprintf(fpphi1, "%.3f\t", model->opt[indexr].phi[k][i][0]);
      fprintf(fpphi1, "%.3f\n", model->opt[indexr].phi[model->nb-1][i][0]);
    }
  }
  fclose(fpphi1);

  for(index=0;index<_NUM_RECORDS_;index++) {
    indexr = model->reportOrder[index];
    for(i=0;i<data->nprey;i++) {
      for(k=0;k<model->nb-1;k++) fprintf(fpphi2, "%.3f\t", model->opt[indexr].phi[k][i][1]);   
      fprintf(fpphi2, "%.3f\n", model->opt[indexr].phi[model->nb-1][i][1]);
    }
  }
  fclose(fpphi2);

  system("mkdir OPTclusters");
  chdir("OPTclusters");

  for(index=0;index<_NUM_RECORDS_;index++) {
    strcpy(addname, optname);
    itoa(index+1, tmpname);
    strcat(addname, tmpname);
    FILE *fpa = fopen(addname, "w");
    fprintf(fpa, "UNIQID\t");
    for(j=0;j<data->nbait;j++) {
      fprintf(fpa, "%s", data->baitName[j]);
      fprintf(fpa, j==(data->nbait-1) ? "\n" : "\t");
    }
    for(k=0;k<data->nprey;k++) {
      fprintf(fpa, "%s\t", data->preyName[k]);
      for(j=0;j<data->nbait;j++) {
        id2 = model->opt[index].z[j];
        fprintf(fpa, "%.2f", model->opt[index].phi[id2][k][0]); /* mean */
        fprintf(fpa, j==(data->nbait-1) ? "\n" : "\t");
      }
    }
    fclose(fpa);
  }

  for(index=0;index<_NUM_RECORDS_;index++) {
    indexr = model->reportOrder[index];
    strcpy(addname, optname1);
    itoa(index+1, tmpname);
    strcat(addname, tmpname);
    FILE *fpa = fopen(addname, "w");
    fprintf(fpa, "UNIQID\t");
    for(j=0;j<data->nbait;j++) {
      fprintf(fpa, "%s", data->baitName[j]);
      fprintf(fpa, j==(data->nbait-1) ? "\n" : "\t");
    }
    for(k=0;k<data->nprey;k++) {
      fprintf(fpa, "%s\t", data->preyName[k]);
      for(j=0;j<data->nbait;j++) {
        for(l=0;l<data->n_b2ip[j];l++) {
          id = data->b2ip[j][l];
          fprintf(fpa, "%.2f", data->d[id][k]);  /* data */
          if(data->n_b2ip[j] > 1 && l < (data->n_b2ip[j]-1)) fprintf(fpa, ","); 
        }
        id2 = model->opt[indexr].z[j];
        fprintf(fpa, "|%.2f", model->opt[indexr].phi[id2][k][0]); /* mean */
        fprintf(fpa, j==(data->nbait-1) ? "\n" : "\t");
      }
    }
    fclose(fpa);
  }


  chdir("..");

}

void reverse(char s[]) {
  int c,i,j;
  for(i=0,j=strlen(s)-1; i < j; i++, j--) {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}

void itoa(int n, char s[]) {
  int i, sign;
  if((sign = n) < 0) n = -n;
  i = 0;
  do{
     s[i++] = n % 10 + '0';
  } while ((n /= 10) > 0);
  if (sign < 0) s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}

void optimizeY(MODEL *model, DATA *data, int k, int *id, const gsl_rng *r) {
  int i,j,l,m,id2;
  double prob[model->np];
  double maxprob;

  /* sample ranMultinom, make probabilities in log scale */
  for(i=0;i<data->nprey;i++) {
    /* likelihood calculation */
    for(l=0;l<model->np;l++) prob[l] = 0.0;
    for(l=0;l<model->np;l++) {
      for(j=0;j<data->nbait;j++) {
        if(model->dp.z[j] == k) {
	  for(m=0;m<data->n_b2ip[j];m++) {
	    id2 = data->b2ip[j][m];
	    prob[l] += logGaussian(data->d[id2][i], model->hdp.omega[l], model->sigma2[i], r);
          }
        }
      }
    }

    /* probability calculation */
    maxprob = vec_max(prob, model->np); 
    for(l=0;l<model->np;l++) prob[l] -= maxprob; 
    /* for(l=0;l<model->np;l++) prob[l] = model->hdp.pi[i][l] * exp(prob[l]); */
    for(l=0;l<model->np;l++) prob[l] = exp(prob[l]);
    id[i] = vec_max_index(prob, model->np); 
  }
}

void optimalCluster(MODEL *model, DATA *data, const gsl_rng *r) {
  int i,d,j,k,pos;
  int inUse[model->nb];
  int id[data->nprey];
  double minlik;
  int proceed;
  /* if no opt, then record it no matter what */
  /* if there is a record and there is an empty spot, just record it */
  /* if there is a record and there are _NUM_RECORDS_ records, then identify the lowest scoring spot and record it */
  for(k=0;k<model->nb;k++) inUse[k] = 0;
  for(j=0;j<data->nbait;j++) inUse[model->dp.z[j]] = 1;

  proceed = 0;
  if(model->optCount < _NUM_RECORDS_) proceed = 1;
  else {
    minlik = vec_min(model->optScores, model->optCount);
    if(model->curlik > minlik) proceed = 1;
  }

  if(proceed) {
    pos = model->optCount < _NUM_RECORDS_ ? model->optCount : vec_min_index(model->optScores, _NUM_RECORDS_);
    for(j=0;j<data->nbait;j++) model->opt[pos].z[j] = model->dp.z[j];
    for(k=0;k<model->nb;k++) {
      if(inUse[k]) {
        for(i=0;i<data->nprey;i++) id[i] = model->hdp.y[k][i];
        for(i=0;i<data->nprey;i++) {
          model->opt[pos].y[k][i] = id[i];
          for(d=0;d<_DIM_;d++) model->opt[pos].phi[k][i][d] = model->hdp.omega[id[i]][d];
        } 
        optimizeY(model, data, k, model->opt[pos].y[k], r);
      }
      else {     
        for(i=0;i<data->nprey;i++) id[i] = model->hdp.y[k][i];
        for(i=0;i<data->nprey;i++) {
          model->opt[pos].y[k][i] = id[i];
          for(d=0;d<_DIM_;d++) model->opt[pos].phi[k][i][d] = model->hdp.omega[id[i]][d];
        }
      }
    }
    model->optScores[pos] = model->curlik;
    if(model->optCount < _NUM_RECORDS_) (model->optCount)++;
  }
}
