#include "clustddp.h"

int checknum(const double x) {
  if(gsl_isnan(x)) { 
    fprintf(stderr, "NaN occurred.\n");
    return 1;
  }
  else if(gsl_isinf(x)) {
    fprintf(stderr, "Infinity occurred.\n");
    return 1;
  }
  else return 0;
}

int checknums(const double *x, int n) {
  int i,status;
  status = 0;
  for(i=0;i<n;i++) {
    if(gsl_isnan(x[i])) status = 1;
  }
  if(status) { 
    fprintf(stderr, "NaN occurred (%d).\n",i);
    return 1;
  }
  status = 0;
  for(i=0;i<n;i++) {
    if(gsl_isinf(x[i])) status = 1;
  }
  if(status) {
    fprintf(stderr, "Infinity occurred (%d).\n",i);
    return 1;
  }
  return 0;
}

double vec_sum(const double *vec, int len) {
  int i;
  double res;
  res=vec[0];
  for(i=1;i<len;i++) res+=vec[i];
  return res;
}

int vec_int_sum(const int *vec, int len) {
  int i;
  int res;
  res=vec[0];
  for(i=1;i<len;i++) res+=vec[i];
  return res;
}

int vec_int_partial_sum(const int *vec, int start, int end) {
  int i;
  int res;
  res=vec[start];
  for(i=start+1;i<=end;i++) res+=vec[i];
  return res;
}


double vec_partial_sum(const double *vec, int start, int end) {
  int i;
  double res;
  res = 0.0;
  for(i=start;i<=end;i++) res += vec[i];
  return res;
}

double vec_partial_mean(const double *vec, int start, int end) {
  int i;
  double res;
  res = 0.0;
  for(i=start;i<=end;i++) res += vec[i];
  res = res / ((double) (end - start + 1));
  return res;
}


double vec_max(const double *vec, int len) {
  int i;
  double res;
  res=vec[0];
  for(i=1;i<len;i++) {
    if(res<vec[i]) res=vec[i];
  }
  return res;
}

double vec_max_cond(const double *vec, int len, int *id) {
  int i, cur, first;
  double res;
  first = -1; 
  cur = 0;
  while(first < 0) {
    if(id[cur]) {
      first = cur;
      break;
    }
    cur++;
  }
  res=vec[first];
  if(first < (len-1)) {
    for(i=(first+1);i<len;i++) {
      if(res<vec[i] && id[i]) res=vec[i];
    }
  }
  return res;
}


int vec_int_max(const int *vec, int len) {
  int i;
  int res;
  res=vec[0];
  for(i=1;i<len;i++) {
    if(res<vec[i]) res=vec[i];
  }
  return res;
}

double vec_min(const double *vec, int len) {
  int i;
  double res;
  res=vec[0];
  for(i=1;i<len;i++) {
    if(res>vec[i]) res=vec[i];
  }
  return res;
}

double vec_mean(const double *vec, int len) {
  double tmp=0.0;
  int i;
  for(i=0;i<len;i++) tmp+=vec[i];
  tmp=tmp/((double) len);
  return tmp;
}

int vec_min_index(const double *vec, int len) {
  int i,index;
  double res;
  if(len == 1) return 0;
  else {
    res=vec[0];
    index = 0;
    for(i=1;i<len;i++) {
      if(res>vec[i]) {
        index = i;
      }
    }
  }
  return index;
}

int vec_max_index(const double *vec, int len) {
  int i,index;
  double res;
  if(len == 1) return 0;
  else {
    res=vec[0];
    index = 0;
    for(i=1;i<len;i++) {
      if(res<vec[i]) {
        index = i;
      }
    }
  }
  return index;
}


double vec_var(const double *vec, int len) {
  double mean=0.0;
  double var=0.0;
  int i;
  for(i=0;i<len;i++) mean+=vec[i];
  mean=mean/((double) len);
  for(i=0;i<len;i++) var+=pow((vec[i]-mean),2);
  var/=((double) (len-1));
  return var;
}

double vec_med(const double *vec, int len)
{
  double new_vec[len];
  double med;
  int i, pk;
  for(i=0;i<len;i++) {
    new_vec[i]=vec[i]; 
  }
  if(len==1) {
    med=vec[0];
    return med;
  }
  else if(len%2==0) {
    gsl_sort(new_vec,1,len);
    pk=(len-2)/2;
    med=(new_vec[pk]+new_vec[pk+1])/2.0;
    return med;
  }
  else {
    gsl_sort(new_vec,1,len);
    pk=(len-1)/2;
    med=new_vec[pk];
    return med;
  }
}


double vec_mad(const double *vec, int len)
{
  double new_vec[len];
  double med, mad;
  int i;

  med = vec_med(vec,len);
  for(i=0;i<len;i++) {
    new_vec[i]=fabs(vec[i] - med); 
  }
  mad = vec_med(new_vec,len);
  return mad;
}

int ranMultinom(const gsl_rng *r, double *p, int K) {
  int i, rr;
  double coin, sum; 
  sum = vec_sum(p,K);
  /*for(i=0;i<K-1;i++) fprintf(stderr, "%.2f\t", p[i]);
  fprintf(stderr, "%.2f\n", p[K-1]); */
  if(sum != 1.0) {
    for(i=0;i<K;i++) p[i] /= sum;
  }
  coin = gsl_ran_flat(r,0.0,1.0);
  sum = p[0];
  rr = 0;
  while(coin > sum) {
    rr++;
    sum += p[rr];
  }
  if(rr >= K) rr = K-1;
  return rr;
}
