
#include "clustddp.h"

void initERING(MODEL *model, ERING *ering, DATA *data) {
  int i;
  ering->count = 0;
  for(i=0;i<_SIZE_RING_;i++) {
    ering->energy[i] = 0.0;
    memoryDPclust(model, &(ering->dp[i]), data);
    memoryHDPprior(model, &(ering->hdp[i]), data);
  }
}

void freeDP(DPclust *dp) {
  free(dp->beta);
  free(dp->z);
}

void freeHDP(MODEL *model, HDPprior *hdp, int nprey) {
  int i;
  free(hdp->eta);
  for(i=0;i<model->np;i++) free(hdp->omega[i]);
  free(hdp->omega);
  for(i=0;i<nprey;i++) free(hdp->pi[i]);
  free(hdp->pi);
  for(i=0;i<model->nb;i++) free(hdp->y[i]);
  free(hdp->y);
}

void freeERING(MODEL *model, ERING *ering, DATA *data) {
  int i;
  for(i=0;i<_SIZE_RING_;i++) {
    freeDP(&(ering->dp[i]));
    freeHDP(model, &(ering->hdp[i]), data->nprey);
  }
}

void initEnergyTruncation(MODEL *model, DATA *data) {
  int n = model->numLadder;
  assert(model->H = (double *) calloc(n, sizeof(double)));
  assert(model->T = (double *) calloc(n, sizeof(double)));
}

void setEnergyTruncation(MODEL *model, DATA *data) {
  model->H[0] = 0.0;
  model->T[0] = 1.0;
}

void resetEnergyTruncation(MODEL *model, DATA *data, double *energy) {
  int i;
  int n = model->niter;
  double range;
  /* int every = n / model->numLadder; */
  
  /* report of previous set */
  fprintf(stderr, "Current energy bounds and temperatures\n");
  /* report */
  fprintf(stderr, "Ladder\tEnergy\tTemperature\n");
  for(i=0;i<model->numLadder;i++) {
    fprintf(stderr, "%d\t%.2f\t%.2f\n", i, model->H[i], model->T[i]);
  }
  fprintf(stderr, "\n");

  gsl_sort(energy, 1, n);
  range = energy[n-1] - energy[0];

  /* for(i=0;i<model->numLadder;i++) model->H[i] = energy[every * i]; */

  /* report */
  fprintf(stderr, "Re-arranged energy bounds and temperatures\n");
  /* report */
  fprintf(stderr, "Ladder\tEnergy\tTemperature\n");
  for(i=0;i<model->numLadder;i++) {
    fprintf(stderr, "%d\t%.2f\t%.2f\n", i, model->H[i], model->T[i]);
  }
}

void rearrangeERING(MODEL *model, DATA *data) {
  int i,k,count;
  int which;
  ERING tmp[model->numLadder];

  /* first copy current ERINGs to a clone */
  for(i=0;i<model->numLadder;i++) initERING(model, &(tmp[i]), data);
  for(i=0;i<model->numLadder;i++) copyERINGtoERING(model, &(model->ering[i]), &(tmp[i]), data);

  fprintf(stderr, "Temporary Rings\n");
  for(i=0;i<model->numLadder;i++) fprintf(stderr, "Ring %d\t", i+1);
  fprintf(stderr, "\n");
  for(i=0;i<model->numLadder;i++) fprintf(stderr, "%d\t", tmp[i].count);
  fprintf(stderr, "\n");

  for(i=0;i<model->numLadder;i++) {
    if(tmp[i].count > 0) {  
      for(k=0;k<tmp[i].count;k++) {
        fprintf(stderr, "%.2f\n", tmp[i].energy[k]);
      }
    }
  }
  /* re-assign based on energy levels */
  for(i=0;i<model->numLadder;i++) model->ering[i].count = 0;
  for(i=0;i<model->numLadder;i++) {
    if(tmp[i].count > 0) {  
      for(k=0;k<tmp[i].count;k++) {
        /* determine which energy set */
        which = model->numLadder - 1;
        while(tmp[i].energy[k] < model->H[which]) which--;
        if(which < 0) which = 0;
        fprintf(stderr, "%d\t%.3f\t%3f\n", which, tmp[i].energy[k], model->H[which]);

        /* copy dp and hdp */
        count = model->ering[which].count;
        model->ering[which].energy[count] = tmp[i].energy[k];
        copyDPclust(model, &(tmp[i].dp[k]), &(model->ering[which].dp[count]), data->nbait);
        copyHDPprior(model, &(tmp[i].hdp[k]), &(model->ering[which].hdp[count]), data->nprey);
        (model->ering[which].count)++;
      }
    }
  }

  fprintf(stderr, "Copied Rings\n");
  for(i=0;i<model->numLadder;i++) fprintf(stderr, "Ring %d\t", i+1);
  fprintf(stderr, "\n");
  for(i=0;i<model->numLadder;i++) fprintf(stderr, "%d\t", model->ering[i].count);
  fprintf(stderr, "\n\n");


  /* free memory for tmp */
  for(i=0;i<model->numLadder;i++) freeERING(model, &(tmp[i]), data);
}

void copyERINGtoERING(MODEL *model, ERING *ering1, ERING *ering2, DATA *data) {
  int i;
  ering2->count = ering1->count;
  for(i=0;i<ering1->count;i++) {
    ering2->energy[i] = ering1->energy[i];
    copyDPclust(model, &(ering1->dp[i]), &(ering2->dp[i]), data->nbait);
    copyHDPprior(model, &(ering1->hdp[i]), &(ering2->hdp[i]), data->nprey);
  }
}

void resetERING(MODEL *model, DATA *data, const gsl_rng *r) {
  /* copy current eringNew's to ering's */
  /* set counters to zero in all eringNew's */
  int i;
  for(i=0;i<model->numLadder;i++) {
    copyERINGtoERING(model, &(model->eringNew[i]), &(model->ering[i]), data);
    fprintf(stderr, "Ering %d with %d entries\n", i+1, model->ering[i].count);
    model->eringNew[i].count = 0;  
  }
}

/* summary print function for the Energy ring */
