#include "clustddp.h"

void copyDPclust(MODEL *model, DPclust *dp1, DPclust *dp2, int nbait) {
  int j;
  dp2->alpha = dp1->alpha;
  for(j=0;j<model->nb;j++) dp2->beta[j] = dp1->beta[j];
  for(j=0;j<nbait;j++) dp2->z[j] = dp1->z[j]; 
}

void copyHDPprior(MODEL *model, HDPprior *hdp1, HDPprior *hdp2, int nprey) {
  int i,j,k;
  hdp2->rho = hdp1->rho;
  hdp2->gamma = hdp1->gamma;
  for(i=0;i<model->np;i++) {
    hdp2->eta[i] = hdp1->eta[i];
    for(k=0;k<_DIM_;k++) hdp2->omega[i][k] = hdp1->omega[i][k];
  }
  for(i=0;i<nprey;i++) {
    for(k=0;k<model->np;k++) hdp2->pi[i][k] = hdp1->pi[i][k];
  }
  for(j=0;j<model->nb;j++) {
    for(i=0;i<nprey;i++) hdp2->y[j][i] = hdp1->y[j][i];
  }
}

int sampleIndex(const gsl_rng *r, int n) {
  int index = ((int) gsl_ran_flat(r, 0.0, ((double) n)));
  if(index == n) index = n-1;
  return index;
}

void copyToERING(MODEL *model, DATA *data, const gsl_rng *r) {
  /* copies dp and hdp to eringNew, not ering */
  int ring, tcount;
  int index;
  double currentEnergy = - loglik(model, data,r) - logPrior(model, data);
  for(ring=(model->numLadder-1);ring>0;ring--) {
    if(currentEnergy > model->H[ring]) break;
  }
  tcount = model->eringNew[ring].count;

  if(tcount < _SIZE_RING_) index = tcount;
  else index = sampleIndex(r, _SIZE_RING_);

  copyDPclust(model, &(model->dp), &(model->eringNew[ring].dp[index]), data->nbait);
  copyHDPprior(model, &(model->hdp), &(model->eringNew[ring].hdp[index]), data->nprey);

  if(tcount < _SIZE_RING_) (model->eringNew[ring].count)++;  
}

void copyFromERING(MODEL *model, DATA *data, int ring, int index) {
  /* copies dp and hdp from ering, not eringNew */
  copyDPclust(model, &(model->ering[ring].dp[index]), &(model->dp), data->nbait);
  copyHDPprior(model, &(model->ering[ring].hdp[index]), &(model->hdp), data->nprey);
}

void EEsampler(MODEL *model, DATA *data, const gsl_rng *r) {
  int index, ring, accept;
  double currentEnergy = - loglik(model, data,r) - logPrior(model, data);
  double mhratio;
  double mh1, mh2, mh3, mh4;
  double H = model->H[model->curLadder];
  double T = model->T[model->curLadder];
  double Hp = model->H[model->curLadder+1];
  double Tp = model->T[model->curLadder+1];

  for(ring=(model->numLadder-1);ring>0;ring--) {
    if(currentEnergy > model->H[ring]) break;
  }
  if(model->ering[ring].count == 0) accept = 0;
  else {
    (model->EEattempt)++;
    index = sampleIndex(r, model->ering[ring].count);

    /* likelihood */
    mh1 = loglikEring(model, data, ring, index, r) + logPriorERING(model, data, ring, index);
    mh4 = mh1;
    mh2 = loglik(model, data, r) + logPrior(model, data);
    mh3 = mh2;
    mh1 = - GSL_MAX(-mh1, H) / T;
    mh2 = - GSL_MAX(-mh2, Hp) / Tp;
    mh3 = - GSL_MAX(-mh3, H) / T;
    mh4 = - GSL_MAX(-mh4, Hp) / Tp;

    /* prior */
    mhratio = mh1 + mh2 - (mh3 + mh4);
    fprintf(stderr, "%d: (%.2f\t%.2f\t%.2f\t%.2f)\n", ring, mh1, mh2, mh3, mh4);
    fprintf(stderr, "(%.2f\t%.2f)\n", mh1+mh2, mh3+mh4);

    /* MH ratio */
    mhratio = GSL_MIN(1.0, exp(mhratio));
    if(gsl_ran_flat(r, 0.0, 1.0) <= mhratio) {
      accept = 1;
      fprintf(stderr, "******************************ACCEPT!!!!!!!!\n");
    }
    else accept = 0;
  }
  if(accept) {
    copyFromERING(model, data, ring, index);
    (model->EEaccept)++;
    model->curlik = loglik(model, data, r) + logPrior(model, data);
    model->curlikHT = -GSL_MAX(-model->curlik, H) / T;
    if(model->H[0] > -model->curlik) model->H[0] = -model->curlik;
  }
}

