# -*- coding: utf-8 -*-
"""
Created on Sat Mar 24 14:00:24 2018

@author: chmaramis
"""

from __future__ import division
import numpy as np
from pandas import *
import functools as ft
import sys
import time

frm = lambda x,y: '{r}/{l}'.format(r=x,l=y) 

clono_def = {'CDR3': ['AA JUNCTION'],
             'VCDR3': ['V-GENE','AA JUNCTION'],
             'JCDR3': ['J-GENE','AA JUNCTION'], 
             'VJCDR3': ['V-GENE','J-GENE','AA JUNCTION'], 
             'VDJCDR3': ['V-GENE','D-GENE','J-GENE','AA JUNCTION']}


def clonotypeComputation(inp_name, clono, out1, t10n, fname):
    
    clono_comps = clono_def[clono]

    frame = DataFrame()
    tp = read_csv(inp_name, iterator=True, chunksize=5000,sep='\t', index_col=0 )
    frame = concat([chunk for chunk in tp]) 


    grouped = frame.groupby(clono_comps)
    x=grouped.size()
    x1=DataFrame(list(x.index), columns=clono_comps)
    x1['Reads']=x.values
    total = sum(x1['Reads'])
    #x1['Reads/Total'] = ['{r}/{l}'.format(r=pr , l = total) for pr in x1['Reads']]
    x1['Reads/Total'] = x1['Reads'].map(ft.partial(frm, y=total))
    x1['Frequency %'] = (100*x1['Reads']/total).map('{:.4f}'.format)

    final = x1.sort_values(by = ['Reads'] , ascending = False)

    final.index=range(1,len(final)+1)
    final.to_csv(out1 , sep = '\t')

    numofclono = len(final)
    clust = len(final[final['Reads'] > 1])
    sing = len (final[final['Reads'] == 1])
    top10 = final[clono_comps + ['Frequency %']].head(10)
    top10.to_csv(t10n , sep = '\t')
    
    summary = [[clono]]
    summary.append([', '.join([top10[c].values[0] for c in clono_comps])])
    summary.append([top10['Frequency %'].values[0]])
    summary.append([numofclono])
    summary.append([clust,'{:.4f}'.format(100*clust/numofclono)])
    summary.append([sing,'{:.4f}'.format(100*sing/numofclono)])
  
    ind = ['Clonotype Definition', 'Dominant Clonotype', 'Frequency', 'Number of Clonotypes' , 'Expanding Clonotypes','Singletons']
    spl = fname.split('_')
    col = [spl[0],'%']

    frsum = DataFrame(summary,index = ind, columns = col)
    
    return frsum


if __name__ == '__main__':   

    start=time.time()

    # Parse input arguments    
    inp_name = sys.argv[1]
    clono = sys.argv[2]
    out1 = sys.argv[3]
    t10n = sys.argv[4]
    sname = sys.argv[5]
    fname = sys.argv[6]
            
    # Execute basic function
    frsum = clonotypeComputation(inp_name, clono, out1, t10n, fname)
    
    # Save output to CSV files
    if not frsum.empty: 
        frsum.to_csv(sname, sep = '\t')
        
    # Print execution time
    stop=time.time()
    print('Runtime:' + str(stop-start))