# -*- coding: utf-8 -*-
"""
Created on Mon Feb 29 11:12:09 2016

@author: chmaramis
"""

from __future__ import division
import numpy as np
from pandas import *
from numpy import nan as NA
import sys
import time



def exclusiveCDR3Func(inputs,thres):
    
    cdr3=DataFrame()
    
    # File A
    cl = DataFrame()
    cl = read_csv(inputs[0] , sep = '\t' , index_col = 0)
    if (thres != 'null'):
                cl = cl[cl['Reads'] > int(thres)]
    cdr3 = cl
    
    # File B
    cl = DataFrame()
    cl = read_csv(inputs[2] , sep = '\t' , index_col = 0)
    if (thres != 'null'):
                cl = cl[cl['Reads'] > int(thres)]
    cl.rename(columns={'Reads':'ReadsB'}, inplace=True)
    cdr3 = cdr3.merge(cl[['AA JUNCTION','ReadsB']], how='left', on='AA JUNCTION')
    
    cdr3['ReadsB'].fillna(0, inplace=True)
        
    cdr3 = cdr3[cdr3['ReadsB'] == 0]
    del cdr3['ReadsB']
    
    cdr3.index = range(1,len(cdr3)+1)
    
    return cdr3    


if __name__ == '__main__':   

    start=time.time()    
    
    # Parse input arguments
    threshold = sys.argv[2]
    arg = sys.argv[3:]
    output = sys.argv[1]
        
    # Execute basic function
    excl = exclusiveCDR3Func(arg,threshold)
    
    # Save output to CSV files
    if not excl.empty:
        excl.to_csv(output , sep = '\t') 

    # Print execution time
    stop=time.time()
    print('Runtime:' + str(stop-start))
