# -*- coding: utf-8 -*-
"""
Created on Mon Feb 29 16:57:12 2016

@author: chmaramis
"""

from __future__ import division
import numpy as np
from pandas import *
from numpy import nan as NA
import sys
import time


def exclusiveVclonoFunc(inputs,thres):

    vClono=DataFrame()
    
    # File A
    cl = DataFrame()
    cl = read_csv(inputs[0] , sep = '\t' , index_col = 0)
    if (thres != 'null'):
                cl = cl[cl['Reads'] > int(thres)]
    vClono = cl
    
    # File B
    cl = DataFrame()
    cl = read_csv(inputs[2] , sep = '\t' , index_col = 0)
    if (thres != 'null'):
                cl = cl[cl['Reads'] > int(thres)]
    cl.rename(columns={'Reads':'ReadsB'}, inplace=True)
    vClono = vClono.merge(cl[['V-GENE','AA JUNCTION','ReadsB']], how='left', on=['V-GENE','AA JUNCTION'])
    
    vClono['ReadsB'].fillna(0, inplace=True)
        
    vClono = vClono[vClono['ReadsB'] == 0]
    del vClono['ReadsB']
    
    vClono.index = range(1,len(vClono)+1)
    
    return vClono    


if __name__ == '__main__':   

    start=time.time()    
    
    # Parse input arguments
    threshold = sys.argv[2]
    arg = sys.argv[3:]
    output = sys.argv[1]
        
    # Execute basic function
    excl = exclusiveVclonoFunc(arg,threshold)
    
    # Save output to CSV files
    if not excl.empty:
        excl.to_csv(output , sep = '\t') 

    # Print execution time
    stop=time.time()
    print('Runtime:' + str(stop-start))
