# -*- coding: utf-8 -*-
"""
Created on Fri Jun 20 14:58:08 2014

@author: chmaramis
"""

from __future__ import division
import numpy as np
from pandas import *
import functools as ft
import sys
import time

frm = lambda x,y: '{r}/{l}'.format(r=x,l=y) 

def repertoireComputation(inp_name, fname):
        
    df = DataFrame()
    df = read_csv(inp_name, sep='\t', index_col=0 )
    #tp = read_csv(inp_name, iterator=True, chunksize=5000,sep='\t', index_col=0 )
    #df = concat([chunk for chunk in tp])     
    
    
    vgroup = df.groupby(['V-GENE'])
    vdi = vgroup.size()
    rep = DataFrame(list(vdi.index), columns=['V-GENE'])
    rep['Reads'] = vdi.values 
    #rep['Reads/Total'] = ['{r}/{l}'.format(r=p , l = len(df)) for p in vdi.values]
    rep['Reads/Total'] = rep['Reads'].map(ft.partial(frm, y=len(df)))
    rep['Frequency %'] = (100*rep['Reads']/len(df)).map('{:.4f}'.format)
    
    rep = rep.sort_values(by = ['Reads'] , ascending = False)
    rep.index = range(1,len(rep)+1)

    su = rep[['V-GENE','Frequency %']].head(10)
    spl = fname.split('_')
    summdf = DataFrame([su['V-GENE'].values[0],su['Frequency %'].values[0]],
                       index = ['Dominant V-GENE','Frequency'], columns = [spl[0]])
    summdf['%'] = ''

    return (rep, su, summdf)


if __name__ == '__main__':   

    start=time.time()

    # Parse input arguments    
    inp_name = sys.argv[1]
    outrep = sys.argv[2]
    summ_rep = sys.argv[3]
    summ_rep2 = sys.argv[4]
    fname = sys.argv[5]
            
    # Execute basic function
    rep, su, summdf = repertoireComputation(inp_name, fname)
    
    # Save output to CSV files
    if not rep.empty: 
        rep.to_csv(outrep, sep = '\t')
    if not su.empty:
        su.to_csv(summ_rep, sep = '\t')
    if not summdf.empty:
        summdf.to_csv(summ_rep2, sep = '\t')
        
    # Print execution time
    stop=time.time()
    print('Runtime:' + str(stop-start))
