# -*- coding: utf-8 -*-
"""
Created on Mon Dec 21 18:26:01 2015

@author: chmaramis
"""

from __future__ import division
import numpy as np
from pandas import *
from numpy import nan as NA
import sys
import time



def publicCDR3Func(inputs,thres):
    
    cdr3=DataFrame()

    for x in range(0,len(inputs),2):
            cl = DataFrame()
            cl = read_csv(inputs[x] , sep = '\t' , index_col = 0)
            #tp = read_csv(inp_name, iterator=True, chunksize=5000,sep='\t', index_col=0 )
            #cl = concat([chunk for chunk in tp]) 
            
            if (thres != 'null'):
                cl = cl[cl['Reads'] > int(thres)]
            
            x1 = inputs[x+1].split('_')
            
            del cl['Reads']
            cl.columns = [cl.columns[0], x1[0]+' '+cl.columns[1], x1[0]+' Relative '+cl.columns[2]]
            
            if cdr3.empty:
                cdr3 = cl
            else:
                cdr3 = cdr3.merge(cl, how='outer', on='AA JUNCTION')
    
    
    col = cdr3.columns
    freqs = col.map(lambda x: 'Frequency' in x)
    reads = col.map(lambda x: 'Reads/Total' in x)
    
    cdr3[col[freqs]] = cdr3[col[freqs]].fillna(0)
    cdr3[col[reads]] = cdr3[col[reads]].fillna('0/*')
    
    cdr3['Num of Patients']= cdr3[col[freqs]].apply(lambda x: np.sum(x != 0), axis=1)

    cdr3 = cdr3[cdr3['Num of Patients'] > 1]

    cdr3.index = range(1,len(cdr3)+1)
    
    return cdr3    


if __name__ == '__main__':   

    start=time.time()    
    
    # Parse input arguments
    threshold = sys.argv[2]
    arg = sys.argv[3:]
    output = sys.argv[1]
        
    # Execute basic function
    mer = publicCDR3Func(arg,threshold)
    
    # Save output to CSV files
    if not mer.empty:
        mer.to_csv(output , sep = '\t') 

    # Print execution time
    stop=time.time()
    print('Runtime:' + str(stop-start))
