__license__ = "MIT"

import unittest
import lc_extend as lc


class SimpleUnitTest(unittest.TestCase):
    def setUp(self):
        import os

        os.environ["http_proxy"] = ""  # work around for IOError: [Errno url error] invalid proxy for http:
        self.examplelc = """(Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN)
(Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN)
(GN??Ma3(GN??Ma6)Mb4GNb4(Fa6)GN)
(GN??(GN??)Ma3(GN??Ma6)Mb4GNb4GN)
(Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN,M)
(A??GN??Ma3(GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(GN??Ma3)(GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??GN??Ma3)(GN??Ma6)Mb4GNb4GN)
(NN??A??GN??Ma3(Ma6)Mb4GNb4(Fa6)GN)
(Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN,M,M)
(A??GN??Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??GN??Ma3)(GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??GN??Ma3)(A??GN??Ma6)Mb4GNb4GN)
(Ma2Ma2Ma3(Ma2Ma3(Ma2Ma6)Ma6)Mb4GNb4GN)
(NN??A??GN??Ma3(A??GN??Ma6)Mb4GNb4GN)
(GNb4(A??(Fa3)GN??Ma3)(GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??GN??Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4GN)
(NN??A??GN??Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??(Fa3)GN??Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN,F)
(NN??A??GN??Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN,F)
(NN??A??GN??Ma3(NN??A??GN??Ma6)Mb4GNb4GN)
(GNb4(NN??A??GN??Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4GN)
(NN??A??GN??Ma3(NN??A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(A??(Fa3)GN??(A??GN??)Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??(Fa3)GN??Ma3(NN??A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN,F)
(GNb4(A??(Fa3)GN??(A??(Fa3)GN??)Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN,F,F)
(NN??A??GN??(NN??A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN)
(GNb4(NN??A??GN??(A??GN??)Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN,F)
(NN??A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(NN??A??GN??)Ma3(A??GN??Ma6)Mb4GNb4(Fa6)GN,F)
(GNb4(NN??A??GN??(A??GN??)Ma3)(A??GN??Ma6)Mb4GNb4(Fa6)GN,F,F)
(NN??A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,F)
(NN??A??GN??(NN??A??GN??)Ma3(NN??A??GN??Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(NN??A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??Ma3(NN??A??GN??(NN??A??(Fa3)GN??)Ma6)Mb4GNb4(Fa6)GN)
(GNb4(NN??A??GN??Ma3)(NN??A??GN??(NN??A??GN??)Ma6)Mb4GNb4(Fa6)GN)
(NN??A??GN??(NN??A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,F)
(NN??A??GN??(NN??A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,F,F)
(A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,NN,NN,A??GN)
(NN??A??GN??(NN??A??GN??)Ma3(NN??A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,F)
(A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,F,NN,NN,A??GN)
(NN??A??(Fa3)GN??(NN??A??GN??)Ma3(NN??A??GN??(NN??A??GN??)Ma6)Mb4GNb4(Fa6)GN)
(A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,NN,NN,NN,F,A??GN)
(A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,NN,NN,NN,NN,A??GN,F)
(A??GN??(A??GN??)Ma3(A??GN??(A??GN??)Ma6)Mb4GNb4(Fa6)GN,NN,NN,NN,NN,A??GN,A??GN,F)
"""
        pass

    def tearDown(self):
        pass


    def test_simple_lc(self):
        import StringIO

        lcinput = ["(Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN)"]
        lchandle = StringIO.StringIO('\n'.join(lcinput))
        m = lc.read_linearcode(lchandle, "logging.log")
        self.assertIsNotNone(m)
        self.assertEqual(1, len(m))

    def test_commad_lc_extend(self):
        import StringIO

        lcinput = ["(Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN,M)"]
        lchandle = StringIO.StringIO('\n'.join(lcinput))
        m = lc.read_linearcode(lchandle, "logging.log", True)
        self.assertIsNotNone(m)
        self.assertEqual(3, len(m))
        self.assertEqual(['M??Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN', 'Ma2Ma3(M??Ma3(Ma6)Ma6)Mb4GNb4GN', 'Ma2Ma3(Ma3(M??Ma6)Ma6)Mb4GNb4GN'],m)

    def test_commad_lc_append(self):
        import StringIO

        lcinput = ["(Ma2Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN,M)"]
        lchandle = StringIO.StringIO('\n'.join(lcinput))
        m = lc.read_linearcode(lchandle, "logging.log")
        self.assertIsNotNone(m)
        self.assertEqual(1, len(m))
        self.assertEqual("((M??)X??)(Ma2Ma3(Ma3)(Ma6)Ma6)Mb4GNb4GN", m[0])

    def test_empty_stream(self):
        """
        should raise IOError
        """
        with self.assertRaises(IOError):
            m = lc.read_linearcode([], "logging.log")
        with self.assertRaises(IOError):
            m = lc.read_linearcode("", "logging.log")
        with self.assertRaises(IOError):
            m = lc.read_linearcode([], "logging.log")

    def test_empty_logger(self):
        """
        should work as usual as logger is defined by default
        """
        import StringIO

        lcinput = ["(Ma3(Ma3(Ma6)Ma6)Mb4GNb4GN)"]
        lchandle = StringIO.StringIO('\n'.join(lcinput))
        m = lc.read_linearcode(lchandle)
        self.assertIsNotNone(m)

    def test_many_lc_extend(self):
        import StringIO

        lchandle = StringIO.StringIO(''.join(self.examplelc))
        m = lc.read_linearcode(lchandle, extend=True)
        self.assertIsNotNone(m)
        self.assertEqual(150, len(m))

    def test_many_lc_append(self):
        import StringIO

        lchandle = StringIO.StringIO(''.join(self.examplelc))
        m = lc.read_linearcode(lchandle)
        self.assertIsNotNone(m)
        self.assertEqual(52, len(m))  # that is equal to number of examples


def run_tests():
    unittest.main()


if __name__ == '__main__':
    run_tests()


