__license__ = "MIT"

import unittest
import linkKEGG as lk


class SimpleUnitTest(unittest.TestCase):
    def setUp(self):
        import os

        os.environ["http_proxy"] = ""  # work around for IOError: [Errno url error] invalid proxy for http:
        pass

    def tearDown(self):
        pass

    def test_no_db_specified(self):
        """should return default glycan path example"""
        m = lk.linked_entries_from_kegg()
        self.assertIn("path", m)
        self.assertIn("G00001", m)


    def test_bad_db(self):
        """"""
        import urllib2

        with self.assertRaises(urllib2.HTTPError):
            m = lk.linked_entries_from_kegg("john", "sally")

    def test_bad_dbentry(self):
        """"""
        import urllib2

        with self.assertRaises(urllib2.HTTPError):
            m = lk.linked_entries_from_kegg("ko", "map000")

    def test_no_links_btn_dbs(self):
        """ should return an empty string, cannot write None to file"""
        m = lk.linked_entries_from_kegg("br", "gl:G10496")
        self.assertEquals(m,"")

