__license__ = "MIT"

import unittest
import findKEGG as fk


class SimpleUnitTest(unittest.TestCase):
    def setUp(self):
        import os

        os.environ["http_proxy"] = ""  # work around for IOError: [Errno url error] invalid proxy for http:
        pass

    def tearDown(self):
        pass

    def test_no_db_specified(self):
        """should raise error"""
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG([], " ")
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG("", " ")
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG(None, " ")

    def test_no_query_specified(self):
        """should raise error"""
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG("glycan", "")
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG("glycan", [])
        with self.assertRaises(IOError):
            m = fk.find_entries_in_KEGG("glycan", None)


    def test_bad_db(self):
        """should raise error"""
        import urllib2

        with self.assertRaises(urllib2.HTTPError):
            m = fk.find_entries_in_KEGG("john", "glucose")

    def test_unfindable_entry(self):
        """should return None"""
        m = fk.find_entries_in_KEGG("glycan", "sally")
        self.assertIsNone(m)

    def test_find_example(self):
        m = fk.find_entries_in_KEGG("glycan", "glucose")
        self.assertIsNotNone(m)
        self.assertIn("GDP-glucose", m)

    def test_query_has_newlines(self):
        """
        should be fine and return entries
        """
        m = fk.find_entries_in_KEGG("glycan", "glucose\n UDP")
        self.assertIsNotNone(m)
        self.assertIn("UDP-D-glucose", m)

