#ifndef DIR_UTIL_H
#define DIR_UTIL_H

#include <list>
#include <iostream>
#include <string>
#include <dirent.h>

/*
 * Parses a directory of sam files
 */
static inline std::list<std::string>
parse_sam_dir(const std::string &directory) {
        DIR *dir;
        struct dirent *ent;
        std::string dir_path = directory;

        dir = opendir(dir_path.c_str());
	// is dir open/valid?
        if(dir == NULL) {
                std::cout << "Not a valid directory" << std::endl;
                exit(EXIT_FAILURE);
        }

        std::list<std::string> sam_files;
        std::string fn;
        std::string ext;
        std::string file_type = ".sam";

	// get all files with a .sam file extension
        while((ent = readdir(dir)) != NULL) {
                fn = dir_path + std::string(ent->d_name);
                ext = fn.substr(fn.length()-4, fn.length());
                if(ext.compare(file_type) == 0) {
                        sam_files.push_back(fn);
                }
        }
        closedir(dir);

        return sam_files;
}

#endif /* DIR_UTIL_H */
