#include "Sam.h"
#include "args.h"
#include "dir_util.h"
#include "alignment_util.h"

#include <iostream>
#include <fstream>

Sam::Sam(std::string sam_fp) : _sam_fp(sam_fp) {}

void Sam::read_sam(cmd_args args) {
	if(args.bam_stream) read_from_stdin();
	else read_from_file(args.sam_fp);
}

void Sam::read_from_stdin() {
	std::string line;
	while(std::getline(std::cin, line)) {
		if(line[0] == '@') continue;
		alignment.push_back(line);
	}
}

void Sam::read_from_file(const std::string &sam_fp) {
	std::ifstream in(sam_fp.c_str());
	if(!in) {
		usage();
		exit(EXIT_FAILURE);
	}

	std::string line;
	while(getline(in, line)) {
		if(line[0] == '@') continue;
		if(is_good_alignment(line))
			alignment.push_back(line);
	}

	in.close();
}


