#ifndef FASTA_H
#define FASTA_H

#include <string>
#include <vector>
#include "FastaRecord.h"

/**
 * Class for dealing with fasta files
 */
class Fasta {
public:
	/** 
 	 * Constructor that sets amr file path 
 	 */
	Fasta(std::string amr_fp);

	/**
 	 * Reads fasta file from file path 
 	 */
	void read_fasta(const std::string &amr_fp);
	
	std::vector<FastaRecord> records;
private:
	std::string _amr_fp;
};

#endif /* FASTA_H */
