#ifndef FASTA_RECORD_H
#define FASTA_RECORD_H

#include <string>
#include <vector>

/**
 * Class for dealing with fasta records
 */
class FastaRecord {
public:
	/**
 	 * Ctor that initializes gene id and gene
 	 */ 
	FastaRecord(std::string gene_id, std::string gene);

	/**
 	 * Returns a string gene id
 	 */
	std::string gene_id() const;

	/**
 	 * Returns the gene associated with gene id
 	 */
	std::string gene() const;

	/**
 	 * Returns the total base hits for a gene
 	 */ 
	int get_base_hits() const;

	/**
 	 * Returns the amount of genes that were hit
 	 * during the gene fraction calculation
 	 */ 
	int gene_hits() const;
	
	/**
 	 *
 	 */ 
	void update_base_hits(const int &index);

	/**
 	 *
 	 */ 
	void update_gene_hits();

	/**
 	 * Searches for a fasta record corresponding
 	 * to gene id
 	 */ 
	static int find_gene(const std::vector<FastaRecord> &records, 
			     const std::string &gene_id, 
                             std::string seq = "");

	/**
 	 * Sorts fasta records by gene id
 	 */ 
	static void sort_by_gene_id(std::vector<FastaRecord> &records);

	/**
 	 * Resets base hits vector to 0's. 
 	 * This occurs after each sample is processed
 	 */ 
	static void reset_base_hits(std::vector<FastaRecord> &records);

	/**
 	 * Resets gene hits primitive to 0.
 	 * This happens after each sample is processed 
 	 */
	static void reset_gene_hits(std::vector<FastaRecord> &records);

	std::vector<int> &base_hits();

	std::string _gene_id;
	std::string _gene;
	std::vector<int> _base_hits;

private:
	int _gene_hits;
};




#endif /* FASTA_RECORD_H */
