#include <string>
#include <iostream>
#include <vector>

#include "int_util.h"
#include "dir_util.h"
#include "args.h"
#include "Fasta.h"
#include "Sam.h"
#include "SamRatio.h"

using namespace std;

int main(int argc, char *argv[]) {
	cmd_args args;
	args = parse_command_line(argc, argv);

	Fasta f(args.amr_fp);
	f.read_fasta(args.amr_fp);	

	if(args.sam_dir) {
		list<string> sam_files = parse_sam_dir(args.sam_fp);
		for(auto &fn : sam_files) {
			args.sam_fp = fn;
			Sam s(args.sam_fp);
			s.read_sam(args);
			generate_samples(f.records, s.alignment, args);
		}
	}
	else {
		Sam s(args.sam_fp);
		s.read_sam(args);
		generate_samples(f.records, s.alignment, args);
	}

	return 0;
}
