#ifndef ALIGNMENTS_H
#define ALIGNMENTS_H

#include <string>
#include <vector>

/**
 * Stores information about an alignment
 */
struct alignment_fields {
    std::string QNAME;
    int FLAG;
    std::string RNAME;
    int POS;
    int MAPQ;
    std::string CIGAR;
    std::string RNEXT;
    int PNEXT;
    int TLEN;
    std::string SEQ;
    std::string QUAL;
};

/**
 * Class for dealing with alignments
 */
class Alignments {
public:
	/**
 	 * Ctor that initializes alignment
 	 */ 
	Alignments(std::string alignment);

	/**
 	 * Stores information about each of the eleven
 	 * required alignment fields
 	 */ 
    	void fill_alignment_fields(const std::string &alignment);

    	std::vector<std::pair<int,char>> cigar();

	inline std::string alignment() const	    { return _alignment;  };

    	inline std::string qname() const            { return field.QNAME; };
    	inline std::string rname() const            { return field.RNAME; };
    	inline std::string cigar() const            { return field.CIGAR; };
    	inline std::string rnext() const            { return field.RNEXT; };
    	inline std::string seq() const              { return field.SEQ;   };
    	inline std::string qual() const             { return field.QUAL;  };

    	inline int flag() const                     { return field.FLAG;  };
    	inline int pos() const                      { return field.POS;   };
    	inline int mapq() const                     { return field.MAPQ;  };
    	inline int pnext() const                    { return field.PNEXT; };
    	inline int tlen() const			    { return field.TLEN;  };

private:
	/**
         * Returns a pair of cigar operations as (occurrence, operation)
         * Ex: 10M5I -> (10, M), (5, I)
         */
    	std::vector<std::pair<int,char>> get_cigar_operations(const std::string &cigar);

    	std::string _alignment;
    	alignment_fields field;
};

#endif /* ALIGNMENTS_H */
