/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.common;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.krumsiek.gepard.common.InvalidFASTAFileException;
import org.krumsiek.gepard.common.Sequence;
import org.krumsiek.gepard.common.SubstitutionMatrix;

public class FASTAReader {
    private static final float NUCLEOTIDE_THRESHOLD = 0.95f;
    private static final int CHARACTERS_FOR_AUTOMATRIX = 250;

    public static Sequence readFile(String file, SubstitutionMatrix substmat) throws FileNotFoundException, IOException, InvalidFASTAFileException {
        String name = null;
        byte[] sequence = null;
        boolean invalidchars = false;
        int ACGTcount = 0;
        boolean[] isACGT = FASTAReader.getACGTChecker();
        int charcount = 0;
        byte[] LCToUC = FASTAReader.getUppercaseMapper();
        File f = new File(file);
        int filelen = (int)f.length();
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        byte[] contents = new byte[filelen];
        in.readFully(contents, 0, filelen);
        if (contents.length == 0 || contents[0] != 62) {
            throw new InvalidFASTAFileException("No status line found");
        }
        int i = 0;
        while (contents[i] != 10 && contents[i] != 13) {
            ++i;
        }
        if (contents[i + 1] == 10) {
            ++i;
        }
        name = new String(contents, 1, i - 1).trim();
        int validcount = 0;
        for (int j = i; j < contents.length; ++j) {
            if (contents[j] == 62) {
                while (contents[j] != 10 && contents[j] != 13) {
                    ++j;
                }
                if (contents[++j] == 10) {
                    ++j;
                }
            }
            contents[j] = LCToUC[contents[j]];
            if (substmat.map(contents[j]) > 0) {
                ++validcount;
            }
            if (substmat.map(contents[j]) >= 0) {
                ++charcount;
            }
            if (!isACGT[contents[j]]) continue;
            ++ACGTcount;
        }
        boolean isnucleotide = (float)ACGTcount / (float)charcount >= 0.95f;
        sequence = new byte[validcount];
        int k = 0;
        for (int j = i; j < contents.length; ++j) {
            if (contents[j] == 62) {
                while (contents[j] != 10 && contents[j] != 13) {
                    ++j;
                }
                if (contents[++j] == 10) {
                    ++j;
                }
            }
            int mapval = substmat.map(contents[j]);
            if (isnucleotide && mapval == 16) {
                mapval = 2;
            }
            if (isnucleotide && mapval > 5) {
                mapval = 5;
            }
            if (mapval > 0) {
                sequence[k++] = mapval;
                continue;
            }
            if (mapval != 0) continue;
            invalidchars = true;
        }
        return new Sequence(sequence, name, isnucleotide, invalidchars);
    }

    private static byte[] getUppercaseMapper() {
        int i;
        byte[] ret = new byte[256];
        Arrays.fill(ret, (byte)10);
        for (i = 65; i <= 90; i = (int)((byte)(i + 1))) {
            ret[i] = i;
        }
        for (i = 97; i <= 122; i = (int)((byte)(i + 1))) {
            ret[i] = (byte)(i - 32);
        }
        return ret;
    }

    private static boolean[] getACGTChecker() {
        boolean[] ret = new boolean[256];
        ret[65] = true;
        ret[67] = true;
        ret[71] = true;
        ret[84] = true;
        ret[78] = true;
        ret[88] = true;
        return ret;
    }

    public static boolean isNucleotideFile(String file) throws IOException, InvalidFASTAFileException {
        int start;
        byte[] LCToUC = FASTAReader.getUppercaseMapper();
        boolean[] isACGT = FASTAReader.getACGTChecker();
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        int readbytes = (int)Math.min(250L, new File(file).length());
        byte[] contents = new byte[readbytes];
        in.readFully(contents, 0, readbytes);
        if (contents.length == 0 || contents[0] != 62) {
            throw new InvalidFASTAFileException("No status line found");
        }
        for (start = 0; start < contents.length && contents[start] != 10 && contents[start] != 13; ++start) {
        }
        if (start == contents.length) {
            throw new InvalidFASTAFileException("End of FASTA status line could not be identified");
        }
        if (contents[start + 1] == 10) {
            ++start;
        }
        int totalCount = 0;
        int acgtCount = 0;
        for (int i = ++start; i < contents.length; ++i) {
            if (contents[i] == 62) {
                while (contents[i] != 10 && contents[i] != 13) {
                    ++i;
                }
                if (contents[++i] == 10) {
                    ++i;
                }
            }
            if (contents[i] == 13 || contents[i] == 10) continue;
            if (isACGT[LCToUC[contents[i]]]) {
                ++acgtCount;
            }
            ++totalCount;
        }
        return (double)acgtCount / (double)totalCount >= (double)0.95f;
    }

    public static int countNuclSeqLength(String file) throws IOException {
        String line;
        int charcount = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(">")) continue;
            charcount += line.length();
        }
        reader.close();
        return charcount;
    }
}

