#!/bin/bash

if [ "$#" -ne 1 ]; then
 echo "[usage:] expression.sh bam.file"
 exit 1;
fi

INPUT_BAM=$1
SAMPLE_ID="sample"
SAMTOOLS=$GALAXY_HOME/package/DAUMSOFT/RNA-seq/Normalization/samtools
HTSEQ_COUNT=$GALAXY_HOME/package/DAUMSOFT/RNA-seq/Normalization/htseq-count
GTF=$GALAXY_HOME/package/DAUMSOFT/RNA-seq/Normalization/gencode.v22.annotation.gtf
EXPRESSION_R=$GALAXY_HOME/package/DAUMSOFT/RNA-seq/Normalization/expression.r

HTSEQ_COUNT_OUT=./$SAMPLE_ID".htseq-count.out"
EXPRESSION_OUT=./out
EXPRESSION_OUT_TMP=./out_tmp

rm -rf  $EXPRESSION_OUT
rm -rf  $EXPRESSION_OUT_TMP

mkdir $EXPRESSION_OUT
mkdir $EXPRESSION_OUT_TMP


$SAMTOOLS view -F 4 $INPUT_BAM |
$HTSEQ_COUNT \
-m intersection-nonempty \
-i gene_id \
-r pos \
-s no \
- $GTF   > $HTSEQ_COUNT_OUT

Rscript $EXPRESSION_R  $HTSEQ_COUNT_OUT 

mv $EXPRESSION_OUT_TMP/$SAMPLE_ID".txt" $EXPRESSION_OUT/ 

