#!/bin/bash

inputFile=$1
outputDir=$3
outputFile=$3/index.html #$2
clonalType=$4
species=$5
locus=$6
filterproductive=$7
clonality_method=$8

dir="$(cd "$(dirname "$0")" && pwd)"
useD="false"
if grep -q "$species.*${locus}D" "$dir/genes.txt" ; then
	echo "species D region in reference db"
	useD="true"
fi
echo "$species"
if [[ "$species" == *"custom"* ]] ; then
	loci=(${locus//;/ })
	useD="true"
	echo "${loci[@]}"
	if [[ "${#loci[@]}" -eq "2" ]] ; then
		useD="false"
	fi
fi
mkdir $3
cp $dir/genes.txt $outputDir
Rscript --verbose $dir/RScript.r $inputFile $outputDir $outputDir $clonalType "$species" "$locus" $filterproductive ${clonality_method} 2>&1
cp $dir/tabber.js $outputDir
cp $dir/style.css $outputDir
cp $dir/script.js $outputDir
cp $dir/jquery-1.11.0.min.js $outputDir
cp $dir/pure-min.css $outputDir
samples=`cat $outputDir/samples.txt`

echo "<html><center><h1><a href='index.html'>Click here for the results</a></h1>Tip: Open it in a new tab (middle mouse button or right mouse button -> 'open in new tab' on the link above)<br />" > $2
echo "<table border = 1>" >> $2
echo "<thead><tr><th>Sample/Replicate</th><th>All</th><th>Productive</th><th>Unique Productive</th><th>Unproductive</th><th>Unique Unproductive</th></tr></thead>" >> $2
while IFS=, read sample all productive perc_prod productive_unique perc_prod_un unproductive perc_unprod unproductive_unique perc_unprod_un
	do
		echo "<tr><td>$sample</td>" >> $2
		echo "<td>$all</td>" >> $2
		echo "<td>$productive (${perc_prod}%)</td>" >> $2
		echo "<td>$productive_unique (${perc_prod_un}%)</td>" >> $2
		echo "<td>$unproductive (${perc_unprod}%)</td>" >> $2
		echo "<td>$unproductive_unique (${perc_unprod_un}%)</td></tr>" >> $2
done < $outputDir/productive_counting.txt
echo "</table border></center></html>" >> $2

echo "<html><head><title>Report on:" >> $outputFile

mkdir $outputDir/circos
cp $dir/circos/* $outputDir/circos/
#CIRCOSTOOLS="/data/galaxy/galaxy-dist/toolsheddependencies/circos/0.64/saskia-hiltemann/cg_circos_plots/bbfdd52d64fd/circos-tools-0.21/tools"
#CIRCOSDIR="/data/galaxy/galaxy-dist/toolsheddependencies/circos/0.64/saskia-hiltemann/cg_circos_plots/bbfdd52d64fd/bin/"

#CIRCOSTOOLS="/home/galaxy/circos/circos-tools-0.22/tools"
#CIRCOSDIR="/home/galaxy/Anaconda3/bin"

USECIRCOS="no"
if [ -d "$CIRCOSDIR" ]; then
	USECIRCOS="yes"
else
	if [ -d "/home/galaxy/Anaconda3/bin" ]; then #hopefully temporary fix
		USECIRCOS="yes"
		CIRCOSTOOLS="/data/galaxy/galaxy-dist/toolsheddependencies/circos/0.64/saskia-hiltemann/cg_circos_plots/bbfdd52d64fd/circos-tools-0.21/tools"
		CIRCOSDIR="/data/galaxy/galaxy-dist/toolsheddependencies/circos/0.64/saskia-hiltemann/cg_circos_plots/bbfdd52d64fd/bin/"
	fi
fi
echo "Using Circos: $USECIRCOS"
sed -i "s%DATA_DIR%$outputDir/circos%" $outputDir/circos/circos.conf
for sample in $samples; do #output the samples to a file and create the circos plots with the R script output
	echo " $sample" >> $outputFile
	
	if [[ "$USECIRCOS" != "yes" ]]; then
		continue
	fi
	
	circos_file="$outputDir/${sample}_VJ_circos.txt"
	echo -e -n "labels$(cat ${circos_file})" > ${circos_file}
	cat "${circos_file}" | $CIRCOSTOOLS/tableviewer/bin/parse-table -configfile $dir/circos/parse-table.conf 2>&1 | $CIRCOSTOOLS/tableviewer/bin/make-conf -dir $outputDir/circos/
	$CIRCOSDIR/circos -conf $outputDir/circos/circos.conf 2>&1
	mv $outputDir/circos/circos.png $outputDir/circosVJ_${sample}.png
	
	
	if [[ "$useD" == "true" ]] ; then
		circos_file="$outputDir/${sample}_VD_circos.txt"
		echo -e -n "labels$(cat ${circos_file})" > ${circos_file}
		cat "${circos_file}" | $CIRCOSTOOLS/tableviewer/bin/parse-table -configfile $dir/circos/parse-table.conf 2>&1 | $CIRCOSTOOLS/tableviewer/bin/make-conf -dir $outputDir/circos/
		$CIRCOSDIR/circos -conf $outputDir/circos/circos.conf 2>&1
		mv $outputDir/circos/circos.png $outputDir/circosVD_${sample}.png
		
		circos_file="$outputDir/${sample}_DJ_circos.txt"
		echo -e -n "labels$(cat ${circos_file})" > ${circos_file}
		cat "${circos_file}" | $CIRCOSTOOLS/tableviewer/bin/parse-table -configfile $dir/circos/parse-table.conf 2>&1 | $CIRCOSTOOLS/tableviewer/bin/make-conf -dir $outputDir/circos/
		$CIRCOSDIR/circos -conf $outputDir/circos/circos.conf 2>&1
		mv $outputDir/circos/circos.png $outputDir/circosDJ_${sample}.png
		
	fi
done
echo "</title><script type='text/javascript' src='jquery-1.11.0.min.js'></script>" >> $outputFile
echo "<link rel='stylesheet' type='text/css' href='pure-min.css'>" >> $outputFile
echo "<script type='text/javascript' src='tabber.js'></script>" >> $outputFile
echo "<script type='text/javascript' src='script.js'></script>" >> $outputFile
echo "<link rel='stylesheet' type='text/css' href='style.css'></head>" >> $outputFile
echo "<div class='tabber'><div class='tabbertab' title='Gene frequencies'>" >> $outputFile

echo "<img src='CDR3LengthPlot.png'/><br />" >> $outputFile
echo "<img src='VFPlot.png'/>" >> $outputFile
if [[ "$useD" == "true" ]] ; then
	echo "<img src='DFPlot.png'/>" >> $outputFile
fi
echo "<img src='VPlot.png'/>" >> $outputFile
if [[ "$useD" == "true" ]] ; then
	echo "<img src='DPlot.png'/>" >> $outputFile
fi
echo "<img src='JPlot.png'/>" >> $outputFile
echo "<img src='AAComposition.png'/>" >> $outputFile
echo "<img src='DReadingFrame.png'/>" >> $outputFile
echo "</div>" >> $outputFile

#Heatmaps

count=1
echo "<div class='tabbertab' title='Heatmaps'><div class='tabber'>" >> $outputFile
for sample in $samples; do
	echo "<div class='tabbertab' title='$sample'><table border='1'><tr>" >> $outputFile
	if [[ "$useD" == "true" ]] ; then
		echo "<td><img src='HeatmapVD_$sample.png'/></td>" >> $outputFile
	fi
	echo "<td><img src='HeatmapVJ_$sample.png'/></td>" >> $outputFile
	if [[ "$useD" == "true" ]] ; then
		echo "<td><img src='HeatmapDJ_$sample.png'/></td>" >> $outputFile
	fi
	echo "</tr></table></div>" >> $outputFile
	count=$((count+1))
done
echo "</div></div>" >> $outputFile

#circos

if [[ "$USECIRCOS" == "yes" ]]; then

	echo "<div class='tabbertab' title='Circos'><div class='tabber'>" >> $outputFile
	for sample in $samples; do
		echo "<div class='tabbertab' title='$sample'><table border='1'><center>" >> $outputFile
		if [[ "$useD" == "true" ]] ; then
			echo "<tr><td>V-D</td><td><img src='circosVD_${sample}.png' width='700' height='700'/></td></tr>" >> $outputFile
		fi
		echo "<tr><td>V-J</td><td><img src='circosVJ_${sample}.png' width='700' height='700'/></td></tr>" >> $outputFile
		if [[ "$useD" == "true" ]] ; then
			echo "<tr><td>D-J</td><td><img src='circosDJ_${sample}.png' width='700' height='700'/></td></tr>" >> $outputFile
		fi
		echo "<center></table></div>" >> $outputFile
		count=$((count+1))
	done
	echo "</div></div>" >> $outputFile
fi
#echo "<div class='tabbertab' title='Interactive'><svg class='chart'></svg><script src='http://d3js.org/d3.v3.min.js'></script></div>" >> $outputFile

hasReplicateColumn="$(if head -n 1 $inputFile | grep -q 'Replicate'; then echo 'Yes'; else echo 'No'; fi)"
echo "$hasReplicateColumn"
#if its a 'new' merged file with replicate info
if [[ "$hasReplicateColumn" == "Yes" ]] ; then
	echo "<div class='tabbertab' title='Clonality'><div class='tabber'>" >> $outputFile
	for sample in $samples; do
		echo "${clonality_method}"
		if [[ "${clonality_method}" == "old" ]] ; then
			echo "in old"
			clonalityScore="$(cat $outputDir/ClonalityScore_$sample.csv)"
			echo "<div class='tabbertab' title='$sample'><table class='pure-table pure-table-striped'>" >> $outputFile
			echo "<thead><tr><th colspan='4'>Clonality Score: $clonalityScore</th></tr></thead>" >> $outputFile

			#replicate,reads,squared
			echo "<tr><td>Replicate ID</td><td>Number of Reads</td><td>Reads Squared</td><td></td></tr>" >> $outputFile
			while IFS=, read replicate reads squared
			do
				echo "<tr><td>$replicate</td><td>$reads</td><td>$squared</td><td></td></tr>" >> $outputFile
			done < $outputDir/ReplicateReads_$sample.csv
			
			#sum of reads and reads squared
			while IFS=, read readsSum squaredSum
				do
					echo "<tr><td>Sum</td><td>$readsSum</td><td>$squaredSum</td></tr>" >> $outputFile
			done < $outputDir/ReplicateSumReads_$sample.csv
			
			#overview
			echo "<tr><td>Coincidence Type</td><td>Raw Coincidence Freq</td><td>Coincidence Weight</td><td>Coincidences, Weighted</td></tr>" >> $outputFile
			while IFS=, read type count weight weightedCount
			do
				if [[ "$type" -eq "1" ]]; then
					echo "<tr><td>$type</td><td>$count</td><td>$weight</td><td>$weightedCount</td></tr>" >> $outputFile
				else
					echo "<tr><td><a href='coincidences_${sample}_${type}.txt'>$type</a></td><td>$count</td><td>$weight</td><td>$weightedCount</td></tr>" >> $outputFile
				fi
				
			done < $outputDir/ClonalityOverView_$sample.csv
			echo "</table></div>" >> $outputFile
		else
			echo "in new"
			clonalityScore="$(cat $outputDir/lymphclon_clonality_${sample}.csv)"
			echo "<div class='tabbertab' title='$sample'>" >> $outputFile
			echo "Lymphclon clonality score: <br />$clonalityScore<br /><br />" >> $outputFile
			echo "<table border = 1>" >> $outputFile
			while IFS=, read type count
			do
				echo "<tr><td>$type</td><td>$count</td></tr>" >> $outputFile
			done < $outputDir/lymphclon_coincidences_$sample.csv
			echo "</table></div>" >> $outputFile
		fi
	done
	echo "</div></div>" >> $outputFile
fi

#hasJunctionData="$(if head -n 1 $inputFile | grep -qE '3V.REGION.trimmed.nt.nb'; then echo 'Yes'; else echo 'No'; fi)"

#if [[ "$hasJunctionData" == "Yes" ]] ; then
if [ -a "$outputDir/junctionAnalysisProd_mean.csv" ] ; then
	echo "<div class='tabbertab' title='Junction Analysis'>" >> $outputFile
	echo "<table class='pure-table pure-table-striped' id='junction_table'> <caption>Productive mean</caption><thead><tr><th>Sample</th><th>count</th><th>V.DEL</th><th>P1</th><th>N1</th><th>P2</th><th>DEL.D</th><th>D.DEL</th><th>P3</th><th>N2</th><th>P4</th><th>DEL.J</th><th>Total.Del</th><th>Total.N</th><th>Total.P</th><th>Median.CDR3</th><thead></tr><tbody>" >> $outputFile
	while IFS=, read Sample unique VDEL P1 N1 P2 DELD DDEL P3 N2 P4 DELJ TotalDel TotalN TotalP median
	do
		echo "<tr><td>$Sample</td><td>$unique</td><td>$VDEL</td><td>$P1</td><td>$N1</td><td>$P2</td><td>$DELD</td><td>$DDEL</td><td>$P3</td><td>$N2</td><td>$P4</td><td>$DELJ</td><td>$TotalDel</td><td>$TotalN</td><td>$TotalP</td><td>$median</td></tr>" >> $outputFile
	done < $outputDir/junctionAnalysisProd_mean.csv
	echo "</tbody></table>" >> $outputFile
	
	echo "<table class='pure-table pure-table-striped' id='junction_table'> <caption>Unproductive mean</caption><thead><tr><th>Sample</th><th>count</th><th>V.DEL</th><th>P1</th><th>N1</th><th>P2</th><th>DEL.D</th><th>D.DEL</th><th>P3</th><th>N2</th><th>P4</th><th>DEL.J</th><th>Total.Del</th><th>Total.N</th><th>Total.P</th><th>Median.CDR3</th><thead></tr><tbody>" >> $outputFile
	while IFS=, read Sample unique VDEL P1 N1 P2 DELD DDEL P3 N2 P4 DELJ TotalDel TotalN TotalP median
	do
		echo "<tr><td>$Sample</td><td>$unique</td><td>$VDEL</td><td>$P1</td><td>$N1</td><td>$P2</td><td>$DELD</td><td>$DDEL</td><td>$P3</td><td>$N2</td><td>$P4</td><td>$DELJ</td><td>$TotalDel</td><td>$TotalN</td><td>$TotalP</td><td>$median</td></tr>" >> $outputFile
	done < $outputDir/junctionAnalysisUnProd_mean.csv
	echo "</tbody></table>" >> $outputFile
	
	echo "<table class='pure-table pure-table-striped' id='junction_table'> <caption>Productive median</caption><thead><tr><th>Sample</th><th>count</th><th>V.DEL</th><th>P1</th><th>N1</th><th>P2</th><th>DEL.D</th><th>D.DEL</th><th>P3</th><th>N2</th><th>P4</th><th>DEL.J</th><th>Total.Del</th><th>Total.N</th><th>Total.P</th><th>Median.CDR3</th><thead></tr><tbody>" >> $outputFile
	while IFS=, read Sample unique VDEL P1 N1 P2 DELD DDEL P3 N2 P4 DELJ TotalDel TotalN TotalP median
	do
		echo "<tr><td>$Sample</td><td>$unique</td><td>$VDEL</td><td>$P1</td><td>$N1</td><td>$P2</td><td>$DELD</td><td>$DDEL</td><td>$P3</td><td>$N2</td><td>$P4</td><td>$DELJ</td><td>$TotalDel</td><td>$TotalN</td><td>$TotalP</td><td>$median</td></tr>" >> $outputFile
	done < $outputDir/junctionAnalysisProd_median.csv
	echo "</tbody></table>" >> $outputFile
	
	echo "<table class='pure-table pure-table-striped' id='junction_table'> <caption>Unproductive median</caption><thead><tr><th>Sample</th><th>count</th><th>V.DEL</th><th>P1</th><th>N1</th><th>P2</th><th>DEL.D</th><th>D.DEL</th><th>P3</th><th>N2</th><th>P4</th><th>DEL.J</th><th>Total.Del</th><th>Total.N</th><th>Total.P</th><th>Median.CDR3</th><thead></tr><tbody>" >> $outputFile
	while IFS=, read Sample unique VDEL P1 N1 P2 DELD DDEL P3 N2 P4 DELJ TotalDel TotalN TotalP median
	do
		echo "<tr><td>$Sample</td><td>$unique</td><td>$VDEL</td><td>$P1</td><td>$N1</td><td>$P2</td><td>$DELD</td><td>$DDEL</td><td>$P3</td><td>$N2</td><td>$P4</td><td>$DELJ</td><td>$TotalDel</td><td>$TotalN</td><td>$TotalP</td><td>$median</td></tr>" >> $outputFile
	done < $outputDir/junctionAnalysisUnProd_median.csv
	echo "</tbody></table>" >> $outputFile
	
	echo "</div>" >> $outputFile
fi

echo "<div class='tabbertab' title='Comparison'><table class='pure-table pure-table-striped'><thead><tr><th>ID</th><th>Include</th></tr></thead>" >> $outputFile
for sample in $samples; do
	echo "<tr><td>$sample</td><td><input type='checkbox' onchange=\"javascript:compareAdd('$sample')\" id='compare_checkbox_$sample'/></td></tr>" >> $outputFile
done
echo "</table><div name='comparisonarea'>" >> $outputFile
echo "<table><tr id='comparison_table_vd'></tr></table>" >> $outputFile
echo "<table><tr id='comparison_table_vj'></tr></table>" >> $outputFile
echo "<table><tr id='comparison_table_dj'></tr></table>" >> $outputFile
echo "</div></div>" >> $outputFile

echo "<div class='tabbertab' title='Downloads'>" >> $outputFile
echo "<table class='pure-table pure-table-striped'>" >> $outputFile
echo "<thead><tr><th>Description</th><th>Link</th></tr></thead>" >> $outputFile
echo "<tr><td>The dataset used to generate the frequency graphs and the heatmaps (Unique based on clonaltype, $clonalType)</td><td><a href='allUnique.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to calculate clonality score (Unique based on clonaltype, $clonalType)</td><td><a href='clonalityComplete.csv'>Download</a></td></tr>" >> $outputFile

echo "<tr><td>The dataset used to generate the CDR3 length frequency graph</td><td><a href='CDR3LengthPlot.csv'>Download</a></td></tr>" >> $outputFile

echo "<tr><td>The dataset used to generate the V gene family frequency graph</td><td><a href='VFFrequency.csv'>Download</a></td></tr>" >> $outputFile
if [[ "$useD" == "true" ]] ; then
	echo "<tr><td>The dataset used to generate the D gene family frequency graph</td><td><a href='DFFrequency.csv'>Download</a></td></tr>" >> $outputFile
fi

echo "<tr><td>The dataset used to generate the V gene frequency graph</td><td><a href='VFrequency.csv'>Download</a></td></tr>" >> $outputFile
if [[ "$useD" == "true" ]] ; then
	echo "<tr><td>The dataset used to generate the D gene frequency graph</td><td><a href='DFrequency.csv'>Download</a></td></tr>" >> $outputFile
fi
echo "<tr><td>The dataset used to generate the J gene frequency graph</td><td><a href='JFrequency.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the AA composition graph</td><td><a href='AAComposition.csv'>Download</a></td></tr>" >> $outputFile

for sample in $samples; do
	if [[ "$useD" == "true" ]] ; then
		echo "<tr><td>The data used to generate the VD heatmap for $sample.</td><td><a href='HeatmapVD_$sample.csv'>Download</a></td></tr>" >> $outputFile
	fi
	echo "<tr><td>The data used to generate the VJ heatmap for $sample.</td><td><a href='HeatmapVJ_$sample.csv'>Download</a></td></tr>" >> $outputFile
	if [[ "$useD" == "true" ]] ; then
		echo "<tr><td>The data used to generate the DJ heatmap for $sample.</td><td><a href='HeatmapDJ_$sample.csv'>Download</a></td></tr>" >> $outputFile
	fi
done

echo "<tr><td>A frequency count of V Gene + J Gene + CDR3</td><td><a href='VJCDR3_count.txt'>Download</a></td></tr>" >> $outputFile

echo "</table>" >> $outputFile
echo "</div></html>" >> $outputFile
