set -e

dir="$(cd "$(dirname "$0")" && pwd)"

input=$1
species=$2
locus=$3
output=$4

declare -A speciesdict

speciesdict=(["Bos taurus functional"]="BosTaurus" ["Bos taurus non-functional"]="BosTaurus" ["Camelus dromedarius functional"]="CamelusDromedarius" ["Camelus dromedarius non-functional"]="CamelusDromedarius" ["Canis lupus familiaris functional"]="CanisLupusFamiliaris" ["Canis lupus familiaris non-functional"]="CanisLupusFamiliaris" ["Danio rerio non-functional"]="DanioRerio" ["Danio rerio functional"]="DanioRerio" ["Homo sapiens functional"]="HomoSapiens" ["Homo sapiens non-functional"]="HomoSapiens" ["Macaca mulatta non-functional"]="MacacaMulatta" ["Macaca mulatta functional"]="MacacaMulatta" ["Mus musculus functional"]="MusMusculus" ["Mus musculus non-functional"]="MusMusculus" ["Mus spretus functional"]="MusSpretus" ["Mus spretus non-functional"]="MusSpretus" ["Oncorhynchus mykiss functional"]="OncorhynchusMykiss" ["Oncorhynchus mykiss non-functional"]="OncorhynchusMykiss" ["Oryctolagus cuniculus functional"]="OryctolagusCuniculus" ["Oryctolagus cuniculus non-functional"]="OryctolagusCuniculus" ["Rattus norvegicus functional"]="RattusNorvegicus" ["Rattus norvegicus non-functional"]="RattusNorvegicus" ["Sus scrofa functional"]="SusScrofa" ["Sus scrofa non-functional"]="SusScrofa" ["BosTaurus"]="BosTaurus" ["CamelusDromedarius"]="CamelusDromedarius" ["CanisLupusFamiliaris"]="CanisLupusFamiliaris" ["DanioRerio"]="DanioRerio" ["HomoSapiens"]="HomoSapiens" ["MacacaMulatta"]="MacacaMulatta" ["MusMusculus"]="MusMusculus" ["MusSpretus"]="MusSpretus" ["OncorhynchusMykiss"]="OncorhynchusMykiss" ["OryctolagusCuniculus"]="OryctolagusCuniculus" ["RattusNorvegicus"]="RattusNorvegicus" ["SusScrofa"]="SusScrofa")

echo "$input $species $locus $output"

java -Xmx64G -jar $IGBLASTWRP/igblastwrp.jar -p 4 -S $species -R $locus ${input} $PWD/blasted_output 2>&1

Rscript --verbose $dir/igblast.r "$PWD/blasted_output.L2.txt" "$output" 2>&1
