#!/usr/bin/perl

use strict;
use File::Basename;
my $dirname = dirname(__FILE__);

my $in = $ARGV[0];
my $yaxis = $ARGV[1];
my $output = $ARGV[2];

open(H,">$output");
print H qq~
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<figure class="highcharts-figure">
    <div id="container"></div>
</figure>~;


my %hash;
open(F,$in);
my $first = <F>;
$first =~s/\n//g;$first =~s/\r//g;
my %level;
my $order = "";
my @headers = split(/\t/,$first);
while(<F>){
	my $line = $_;
	$line =~s/\n//g;$line =~s/\r//g;$line =~s/\"//g;
	my @infos = split(/\t/,$line);
	my $cat = $infos[0];
	for (my $i = 1; $i <= $#infos; $i++){
		$hash{$cat}{$headers[$i]}.= $infos[$i]."\n";
		if ($order !~/$headers[$i]/){
			$order .= $headers[$i]."|";
		}
		$level{$headers[$i]}=1;
	}
}
close(F);

my @categories = split(/\|/,$order);

my $categories = "\"".join("\",\"",@categories)."\"";
my %series;
foreach my $cat(keys(%hash)){
	my $refhash = $hash{$cat};
	my %subhash = %$refhash;
	foreach my $header(@categories){
		my $values = $hash{$cat}{$header};
		$values =~s/;/\n/g;
		if ($values =~/\d+/){
			open(F,">inforcalc");print F $values;close(F);
			my $cmd = `Rscript $dirname/calc.r <inforcalc`;
			unlink("infocalc");
			my ($min,$max,$quantile1,$quantile2,$quantile3,$quantile4,$quantile5) = split(";",$cmd);	
			$series{$cat} .= " [$min,$quantile2,$quantile3,$quantile4,$max],\n";
		}
		else{
			$series{$cat} .= " [0,0,0,0,0],\n";
		}
	}
}

my $javascript = qq~
<script type='text/javascript'>
Highcharts.chart('container', {

    chart: {
        type: 'boxplot'
    },
    legend: {
        enabled: true
    },
    title: {
        text: ''
    },
    xAxis: {
        categories: [$categories]
    },
    yAxis: {
        title: {
            text: '$yaxis'
        }
    },

    series: [
    ~;
foreach my $cat(keys(%hash)){
	$javascript .= "{name: '$cat',\n";
	my $values = $series{$cat};
	chop($values);chop($values);
	$javascript .= "data: [ $values ] },\n";
}
chop($javascript);chop($javascript);
$javascript .= "]\n });\n";
$javascript .= "</script>";
print H $javascript;
close(H);


