use strict;
use warnings;
use File::Basename; 
use Cwd;
use File::Path qw(make_path remove_tree);
die qq(
Bad numbr of inputs

) if(!@ARGV);


my $player_options = "";
my $contra_output;
my $contra_dir;

my $dir = getcwd;
my $variable;

foreach my $input (@ARGV) 
{
	my @tmp = split "::", $input;
	
	if($tmp[0] eq "PLAYEROPTION") 
	{
		$variable = $tmp[1];
		$variable =~ s/=/ /g;
		print "$variable\n";
		$player_options = "$player_options $variable";
	}
	elsif($tmp[0] eq "CONTRAOUTPUT") 
	{
		$contra_output = $tmp[1];
	}  
	elsif($tmp[0] eq "CONTRADIR") 
	{
		$contra_dir = $tmp[1];
	}  
	else 
	{
		die("Unknown Input: $input\n");
	}
}


my $working_dir = "CONTRA_OUTPUT";
make_path($contra_dir);
#remove extension

#run contra 
system ("contra.py -o $working_dir $player_options > /dev/null 2>&1");


#set html
#print "$contra_output - $working_dir\n";
open(HTML, ">$contra_output");
print HTML "<html><head><title>Contra: Copy Number Analysis for Targeted Resequencing</title></head><body><h3>Contra Output Files:</h3><p><ul>\n";
move_files($working_dir);
print HTML "</ul></p>\n";
close(HTML);

sub move_files
{
	my $local_dir = $_[0];
	opendir(DIR, $local_dir);
	#print ("Openning: $local_dir\n");
	my @FILES= readdir(DIR); 
	closedir(DIR);
	foreach my $file (@FILES) 
	{
		if ($file eq "." || $file eq "..")
		{
			#print ("./ or ../ skipped\n");
		}
		elsif (-d "$local_dir/$file")
		{
			#print ("moving to: $local_dir/$file\n");
			move_files("$local_dir/$file");
		}
		elsif (-f "$local_dir/$file")
		{
			#print ("mv $local_dir/$file $contra_dir\n");
			print HTML "<li><a href=$file>$file</a></li>\n";
			system ("mv $local_dir/$file $contra_dir");
		}
		else
		{
			die("Unrecognized file generated: $file\n");
		}
		
		
	}
	
}

