#Remote-blast "factory object" creation and blast-parameter initialization

  use Bio::Tools::Run::RemoteBlast;
  use strict;
  my $prog = 'blastp';
  my $db   = 'swissprot';
  my $e_val= '1e-10';
my ($input,$output)=@ARGV;
  my @params = ( '-prog' => $prog,
         '-data' => $db,
         '-expect' => $e_val,
         '-readmethod' => 'SearchIO' );

  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);

  #change a paramter
#  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';

  #remove a parameter
 # delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};

  my $v = 1;
  #$v is just to turn on and off the messages

  my $str = Bio::SeqIO->new(-file=>$input , '-format' => 'fasta' );

  while (my $input = $str->next_seq()){
    #Blast a sequence against a database:

    #Alternatively, you could  pass in a file with many
    #sequences rather than loop through sequence one at a time
    #Remove the loop starting 'while (my $input = $str->next_seq())'
    #and swap the two lines below for an example of that.
    my $r = $factory->submit_blast($input);
    #my $r = $factory->submit_blast('amino.fa');

    print STDERR "waiting..." if( $v > 0 );
    while ( my @rids = $factory->each_rid ) {
      foreach my $rid ( @rids ) {
        my $rc = $factory->retrieve_blast($rid);
        if( !ref($rc) ) {
          if( $rc < 0 ) {
            $factory->remove_rid($rid);
          }
          print STDERR "." if ( $v > 0 );
          sleep 5;
        } else {
          my $result = $rc->next_result();
          #save the output
          # my $filename = $result->query_name()."\.out";
	  my $filename="";
          $factory->save_output($output);
          $factory->remove_rid($rid);
          #print "\nQuery Name: ", $result->query_name(), "\n";
          #while ( my $hit = $result->next_hit ) {
          #  next unless ( $v > 0);
          #  print "\nhit name is ", $hit->name, "\n";
          #  while( my $hsp = $hit->next_hsp ) {
          #    print "HSP Len is ", $hsp->length('total'), " ",
          # " E-value is ", $hsp->evalue, " Bit score ",
          # $hsp->score, " \t",
          # " Query loc: ",$hsp->query->start, " ",
          # $hsp->query->end," ",
          # " Sbject loc: ",$hsp->hit->start, " ",
          # $hsp->hit->end,"\n";
          #  }
          #}
        }
      }
    }
  }

  # This example shows how to change a CGI parameter:
#  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM25';

  # And this is how to delete a CGI parameter:
 # delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};
