package hmdb_apiTest ;

use diagnostics; # this gives you more debugging information
use warnings;    # this warns you of bad practices
use strict;      # this prevents silly errors
use Exporter ;
use Carp ;

use Data::Dumper ;

our $VERSION = "1.0";
our @ISA = qw(Exporter);
our @EXPORT = qw( getMetaboliteFeaturesTest buildMetabolitesArrayTest setMetaboliteAcurrateMzToModesMzTest);
our %EXPORT_TAGS = ( ALL => [qw( getMetaboliteFeaturesTest buildMetabolitesArrayTest setMetaboliteAcurrateMzToModesMzTest)] );

use lib '/Users/fgiacomoni/Inra/labs/perl/downloader-bank-hmdb/lib' ;
use hmdb_api qw( :ALL ) ;


sub getMetaboliteFeaturesTest {
	my ($xml) = @_ ;
    my $oObject = hmdb_api->new() ;
    my ($res, $nb) = $oObject->getMetaboliteFeatures($xml) ;
    
#    print $res ;
    return ($nb) ;
}


sub buildMetabolitesArrayTest {
	my ($met, $header) = @_ ;
    my $oObject = hmdb_api->new() ;
    my ($res) = $oObject->buildMetabolitesArray($met, $header) ;
#    print Dumper $res ;
    return ($res) ;
}

## SUB TEST for 
sub setMetaboliteAcurrateMzToModesMzTest {
    # get values
    my ( $format, $met ) = @_;
    
    my $var2 = hmdb_api->new() ;
    my $var3 = $var2->setMetaboliteAcurrateMzToModesMz($format, $met, 1.007825, 0.0005486, 1) ;
    
    return($var3) ;
}
## End SUB


1 ;