/*
 * Decompiled with CFR 0.152.
 */
package blasttools;

import blasttools.Range;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Sacc {
    ArrayList<Range> ranges;
    String title;
    int sLen;

    public Sacc(String title, int sLen) {
        this.title = title;
        this.sLen = sLen;
    }

    public void addRange(int start, int end, String qSeqId, double pIdent) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (r.start != start || r.end != end || !r.qSeqId.equals(qSeqId)) continue;
            return;
        }
        this.ranges.add(new Range(start, end, qSeqId, pIdent));
    }

    void sortRanges() {
        for (int i = 1; i < this.ranges.size(); ++i) {
            int j;
            Range r = this.ranges.get(i);
            for (j = i - 1; j >= 0 && this.ranges.get((int)j).start > r.start; --j) {
                this.ranges.set(j + 1, this.ranges.get(j));
            }
            this.ranges.set(j + 1, r);
        }
    }

    String sumRanges() {
        Range r;
        int i;
        int length = 0;
        StringBuilder sb = new StringBuilder();
        this.sortRanges();
        for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
            Range r2 = this.ranges.get(i2);
            int overlap = 0;
            for (int j = i2 - 1; j >= 0; --j) {
                overlap += r2.getOverlap(this.ranges.get(j));
            }
            length += r2.getLength() - overlap;
        }
        sb.append(this.ranges.size());
        sb.append("\t");
        sb.append(length);
        sb.append("\t");
        sb.append(this.sLen);
        sb.append("\t");
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        double coverage = (double)length / (double)this.sLen;
        sb.append(df.format(coverage));
        sb.append("\t");
        int totalLength = 0;
        double total = 0.0;
        for (i = 0; i < this.ranges.size(); ++i) {
            r = this.ranges.get(i);
            totalLength += r.getLength();
            total += r.getRelPIdent();
        }
        sb.append(df.format(total / (double)totalLength));
        sb.append("\t");
        sb.append(this.title);
        sb.append("\t");
        for (i = 0; i < this.ranges.size(); ++i) {
            r = this.ranges.get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append(r.qSeqId);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ranges != null) {
            sb.append(this.sumRanges());
        } else {
            sb.append("\t");
        }
        return sb.toString();
    }
}

