/*
 * Decompiled with CFR 0.152.
 */
package blasttools;

import blasttools.Processor;
import java.io.File;

public class BlastTools {
    static Processor processor;
    static File src;

    static boolean readArgs(String[] args) throws Exception {
        boolean sane = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() > 1 && args[i].startsWith("-")) {
                char opt = args[i].charAt(1);
                switch (opt) {
                    case 't': {
                        processor = Processor.getProcessor(args[i + 1]);
                        break;
                    }
                    default: {
                        sane = false;
                    }
                }
            }
            if (i == args.length - 1 && !(src = new File(args[i])).exists()) {
                throw new Exception(args[i] + " not found");
            }
            if (processor != null) continue;
            sane = false;
        }
        return src != null && sane;
    }

    public static void main(String[] args) {
        try {
            if (BlastTools.readArgs(args)) {
                processor.readConfig();
                processor.read(src);
                processor.write(src.getName());
            } else {
                System.out.println("Usage: java BlastTools -t (blastn|blastp) <input-file>\n    blastn: compute blastn (nucleotide) summary\n    blastp: compute blastp (protein) summary");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

