/*
 * Decompiled with CFR 0.152.
 */
package blast;

import blasttools.Processor;
import blasttools.Sacc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BlastSummary
extends Processor {
    String type;
    String configMaster;
    static String[] ncols = new String[]{"sacc", "sstart", "send", "stitle", "pident", "sstrand", "slen"};
    static String[] pcols = new String[]{"sacc", "sstart", "send", "stitle", "pident", "slen"};
    static String configPath = "/blasttools/config.json";
    static String outputHeading = "sacc\tnaccs\tlength\tslen\tcov\tav-pident\tstitle\tqseqids\n";
    HashMap<String, Sacc> map;

    public BlastSummary(String type) {
        this.type = type;
        this.configMaster = type.equals("N") ? "blastn" : "blastp";
        this.map = new HashMap();
    }

    @Override
    public void readConfig() throws Exception {
        String[] cols = this.type.equals("N") ? ncols : pcols;
        this.config = this.loadConfig(this.configMaster, configPath, cols);
        if (this.config == null) {
            throw new Exception("invalid config");
        }
    }

    @Override
    protected void read(File src) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(src));
        String line = r.readLine();
        int sacc = this.intVal("sacc", this.config);
        int sstart = this.intVal("sstart", this.config);
        int send = this.intVal("send", this.config);
        int slen = this.intVal("slen", this.config);
        int pident = this.intVal("pident", this.config);
        int sstrand = this.type.equals("N") ? this.intVal("sstrand", this.config) : 0;
        int stitle = this.intVal("stitle", this.config);
        int qseqid = this.intVal("qseqid", this.config);
        while (line != null) {
            String[] cols = line.split("\t");
            if (cols.length > 11 && cols[sacc].length() > 0 && this.isInt(cols[sstart]) && this.isInt(cols[send]) && this.isInt(cols[slen]) && this.isDouble(cols[pident]) && cols[qseqid].length() > 0 && (!this.type.equals("N") || cols[sstrand].length() > 0)) {
                Sacc mySacc;
                int sStart = Integer.parseInt(cols[sstart]);
                int sEnd = Integer.parseInt(cols[send]);
                int sLen = Integer.parseInt(cols[slen]);
                if (this.type.equals("N") && cols[sstrand].equals("minus")) {
                    int temp = sEnd;
                    sEnd = sStart;
                    sStart = temp;
                }
                String key = cols[sacc].trim();
                String qSeqId = cols[qseqid].trim();
                String sTitle = cols[stitle].trim();
                double pIdent = Double.parseDouble(cols[pident]);
                if (this.map.containsKey(key)) {
                    mySacc = this.map.get(key);
                    mySacc.addRange(sStart, sEnd, qSeqId, pIdent);
                } else {
                    mySacc = new Sacc(sTitle, sLen);
                    mySacc.addRange(sStart, sEnd, qSeqId, pIdent);
                    this.map.put(key, mySacc);
                }
            }
            line = r.readLine();
        }
    }

    @Override
    protected void write(String srcName) throws Exception {
        Set<String> keys = this.map.keySet();
        Iterator<String> iter = keys.iterator();
        String newFileName = "summary_" + this.shortFileName(srcName) + ".txt";
        File dest = new File(newFileName);
        if (dest.exists() && !dest.delete()) {
            throw new Exception("Failed to create " + newFileName);
        }
        dest.createNewFile();
        FileOutputStream fos = new FileOutputStream(dest);
        fos.write(outputHeading.getBytes());
        while (iter.hasNext()) {
            String key = iter.next();
            fos.write(key.getBytes());
            fos.write(9);
            Sacc sacc = this.map.get(key);
            fos.write(sacc.toString().getBytes());
            fos.write(10);
        }
    }
}

