/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package javax.wadls;

import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.wadls.extensions.schema.Schema;
import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * This interface represents the &lt;types&gt; section of a WSDL document.
 * 
 * @author Zixin Wu (wuzixin@uga.edu)
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public interface Params extends java.io.Serializable,ModelReferenceExtensible
{
	/**
	 * Get the XSD simpleType with the given name.
	 * @param name The QName of the type
	 * @return A DOM Element representing the simpleType
	 * @throws WADLSException 
	 */
	
	public Element getXSDElement(String xpath) throws WADLSException;
	
	/**
	 * Return a list of XSD elements contained in the startElement, search in only 1 level depth. 
	 * @param startXSDElement
	 * @return A list of XSD elements contained in the startElement. If no XSD element is contained, the list has 0 element.
	 * @throws WADLSException
	 */
	public List getXSDElementsInComplexType(Element startXSDElement) throws WADLSException;
	
	/**
	 * Return a list of XSD elements contained in the startElement, search in only 1 level depth. 
	 * @param startXSDComplexType
	 * @return A list of XSD elements contained in the startElement. If no XSD element is contained, the list has 0 element.
	 * @throws WADLSException
	 */
	public List getXSDElementsInElement(Element startXSDComplexType) throws WADLSException;
	
	/**
	 * Get the modelReference on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @return The modelReference
	 */
	public ModelReference getModelReference(Element startElement, String path, Application app) throws WADLSException, URISyntaxException;
	
	/**
	 * Set the modelReference on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @param modelReference The desired modelReference
	 */
	public void addModelReference(Element startElement, String path, ModelReference modelReference) throws WADLSException;
	
	public List<ModelReference> getModelReferences(Element startElement, String path, Application app) throws WADLSException, URISyntaxException;
	
	public void setModelReferences(Element startElement, String path, List<ModelReference> refs) throws WADLSException;
	
	/**
	 * Get the LiftingSchemaMapping on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @return The schemaMapping value
	 */
	public String getLiftingSchemaMapping(Element startElement, String path) throws WADLSException;
	
	/**
	 * Set the LiftingSchemaMapping on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @param schemaMapping The desired schemaMapping
	 */
	public void setLiftingSchemaMapping(Element startElement, String path, String schemaMapping) throws WADLSException;
	
	/**
	 * Get the LiftingSchemaMapping on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @return The schemaMapping value
	 */
	public String getLoweringSchemaMapping(Element startElement, String path) throws WADLSException;
	
	/**
	 * Set the LiftingSchemaMapping on the element located by the given path.
	 * @param startElement The starting element of the path
	 * @param path
	 * @param schemaMapping The desired schemaMapping
	 */
	public void setLoweringSchemaMapping(Element startElement, String path, String schemaMapping) throws WADLSException;

	/**
	 * Set the documentation element for this document. This dependency
	 * on org.w3c.dom.Element should eventually be removed when a more
	 * appropriate way of representing this information is employed.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentationElement(Element docEl);
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement();
}